/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.maven;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.client.ConnectionOptions;
import com.xebialabs.deployit.client.Container;
import com.xebialabs.deployit.client.DarPackager;
import com.xebialabs.deployit.client.DeployitCli;
import com.xebialabs.deployit.client.DeploymentListener;
import com.xebialabs.deployit.client.DeploymentOptions;
import com.xebialabs.deployit.core.api.dto.RepositoryObject;
import com.xebialabs.deployit.maven.MavenContainer;
import com.xebialabs.deployit.maven.MavenDeployable;
import com.xebialabs.deployit.maven.MavenDeployed;
import com.xebialabs.deployit.maven.listener.MavenDeploymentListener;
import com.xebialabs.deployit.maven.packager.MavenDarPackager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.wagon.authentication.AuthenticationInfo;

public abstract class AbstractDeployitMojo
extends AbstractMojo {
    protected MavenProject project;
    protected String mainArtifactName;
    protected boolean skipMode;
    protected String orchestrator;
    protected boolean testMode;
    protected boolean failIfNoStepsAreGenerated;
    private String serverAddress;
    private int port;
    private String username;
    private String password;
    private String context;
    private String server;
    protected boolean secured;
    private String environmentId;
    protected List<MavenDeployed> deployeds;
    protected List<MavenDeployable> deployables = Lists.newArrayList();
    protected List<MavenContainer> environment;
    protected boolean timestampedVersion;
    protected boolean deletePreviouslyDeployedDar;
    protected boolean generateDeployedOnUpgrade;
    protected boolean cancelTaskOnError;
    protected boolean explicitDeployeds;
    private DarPackager packager;
    protected DeployitCli deployitClient;
    private WagonManager wagonManager;

    protected DeployitCli getClient() {
        if (this.deployitClient == null) {
            ConnectionOptions options = new ConnectionOptions();
            options.setHost(this.serverAddress);
            options.setPort(this.port);
            options.setUsername(this.getUsername());
            options.setPassword(this.getPassword());
            options.setContext(this.context);
            options.setSecured(this.secured);
            this.deployitClient = new DeployitCli(options, (DeploymentListener)new MavenDeploymentListener(this.getLog()));
        }
        return this.deployitClient;
    }

    protected void deploy() throws MojoExecutionException {
        RepositoryObject deploymentPackage = this.importDar();
        RepositoryObject environment = this.fetchEnvironment();
        DeploymentOptions deploymentOptions = new DeploymentOptions();
        deploymentOptions.setSkipMode(this.skipMode);
        deploymentOptions.setTestMode(this.testMode);
        deploymentOptions.setFailIfNoStepsAreGenerated(this.failIfNoStepsAreGenerated);
        deploymentOptions.setDeletePreviouslyDeployedArtifact(this.deletePreviouslyDeployedDar);
        deploymentOptions.setExplicitMappings(this.explicitDeployeds);
        deploymentOptions.setGenerateDeployedOnUpgrade(this.generateDeployedOnUpgrade);
        deploymentOptions.setCancelTaskOnError(this.cancelTaskOnError);
        deploymentOptions.setOrchestrator(this.orchestrator);
        this.getLog().info((CharSequence)String.format("-- Deploy %s on %s", deploymentPackage.getId(), environment.getId()));
        this.getClient().deploy(deploymentPackage.getId(), environment.getId(), this.deployeds, deploymentOptions, (DeploymentListener)new MavenDeploymentListener(this.getLog()));
    }

    protected RepositoryObject importDar() throws MojoExecutionException {
        File darFile = this.getPackager().perform();
        this.getLog().info((CharSequence)("Import dar file " + darFile));
        return this.getClient().importPackage(darFile.getPath(), (DeploymentListener)new MavenDeploymentListener(this.getLog()));
    }

    protected void undeploy() throws MojoExecutionException {
        this.getClient().undeployAndWait(this.environmentId + "/" + this.mainArtifactName);
    }

    protected RepositoryObject fetchEnvironment() throws MojoExecutionException {
        if (Strings.emptyToNull((String)this.environmentId) == null) {
            throw new MojoExecutionException("environmentId is not set");
        }
        try {
            this.getLog().info((CharSequence)("read the environment " + this.environmentId));
            RepositoryObject repositoryObject = this.getClient().get(this.environmentId);
            if (this.getLog().isDebugEnabled() && repositoryObject != null) {
                this.getLog().debug((CharSequence)(" dump members of " + this.environmentId));
                for (Object m : (List)repositoryObject.getValues().get("members")) {
                    this.getLog().debug((CharSequence)("  -- member " + m));
                }
            }
            return repositoryObject;
        }
        catch (Exception e) {
            this.getLog().debug((CharSequence)e.getMessage());
            if (this.environment == null) {
                throw new MojoExecutionException("Cannot fetch environment " + this.environmentId + " and no members are defined in <environnment>", e);
            }
            this.getLog().info((CharSequence)"Create the members of environment");
            ArrayList members = Lists.newArrayList();
            for (MavenContainer each : this.environment) {
                this.getLog().info((CharSequence)(" create " + each.getId()));
                this.getClient().create((Container)each);
                if (!each.isAddedToEnvironment()) continue;
                members.add(each.getId());
            }
            this.getLog().info((CharSequence)("Create environment " + this.environmentId));
            MavenContainer ciEnvironment = new MavenContainer();
            ciEnvironment.setId(this.environmentId);
            ciEnvironment.setType("Environment");
            ciEnvironment.addParameter("members", members);
            return this.getClient().create((Container)ciEnvironment);
        }
    }

    DarPackager getPackager() {
        if (this.packager == null) {
            this.packager = new MavenDarPackager(this.project, this.getLog(), this.timestampedVersion || this.isSnapshotVersion());
            if (this.deployables.isEmpty()) {
                this.addMainArtifact();
            }
            this.packager.addDeployables((Collection)Lists.transform(this.deployables, (Function)new Function<MavenDeployable, MavenDeployable>(){

                public MavenDeployable apply(MavenDeployable input) {
                    input.setProject(AbstractDeployitMojo.this.project);
                    return input;
                }
            }));
        }
        return this.packager;
    }

    private void addMainArtifact() {
        try {
            MavenDeployable mainArtifactDeployable = this.generateMainDeployable();
            if (mainArtifactDeployable != null) {
                this.deployables.add(mainArtifactDeployable);
            }
        }
        catch (MojoExecutionException e) {
            e.printStackTrace();
        }
    }

    private MavenDeployable generateMainDeployable() throws MojoExecutionException {
        String ciType;
        String packaging = this.project.getPackaging();
        if (packaging.equalsIgnoreCase("dar") || packaging.equalsIgnoreCase("pom")) {
            this.getLog().debug((CharSequence)("No main artifact for this packaging " + packaging));
            return null;
        }
        if (packaging.equalsIgnoreCase("war")) {
            ciType = "jee.War";
        } else if (packaging.equalsIgnoreCase("ear")) {
            ciType = "jee.Ear";
        } else {
            this.getLog().error((CharSequence)"Unsupported pom packaging type. You must supply the deployable definition for the main artifact.");
            return null;
        }
        MavenDeployable mainArtifact = new MavenDeployable();
        mainArtifact.setType(ciType);
        mainArtifact.setGroupId(this.project.getGroupId());
        mainArtifact.setArtifactId(this.mainArtifactName);
        File file = this.project.getArtifact().getFile();
        if (file == null) {
            throw new MojoExecutionException("Cannot automatically discovery main artifact file location. You must supply the deployable definition for the main artifact.");
        }
        mainArtifact.setLocation(file);
        return mainArtifact;
    }

    private boolean isSnapshotVersion() {
        return this.project.getVersion().contains("SNAPSHOT");
    }

    public String getUsername() {
        if (this.username == null) {
            this.getLog().debug((CharSequence)("No username defined in pom.xml and no system property defined either. Trying to look up username in settings.xml under server element " + this.server));
            AuthenticationInfo authenticationInfo = this.wagonManager.getAuthenticationInfo(this.server);
            if (authenticationInfo == null) {
                this.getLog().warn((CharSequence)String.format("In settings.xml server element '%s' was not defined. Using default username.", this.server));
                return null;
            }
            if (authenticationInfo.getUserName() != null) {
                this.getLog().debug((CharSequence)String.format(" username '%s' found in the settings.xml file", authenticationInfo.getUserName()));
                return authenticationInfo.getUserName();
            }
            this.getLog().warn((CharSequence)String.format("In settings.xml no username was found for server element '%s'. Does the element exist? Using default username.", this.server));
            return null;
        }
        return this.username;
    }

    public String getPassword() {
        if (this.password == null) {
            this.getLog().debug((CharSequence)("No password defined in pom.xml and no system property defined either. Trying to look up password in settings.xml under server element " + this.server));
            AuthenticationInfo authenticationInfo = this.wagonManager.getAuthenticationInfo(this.server);
            if (authenticationInfo == null) {
                this.getLog().warn((CharSequence)String.format("In settings.xml server element '%s' was not defined. Using default password.", this.server));
                return null;
            }
            if (authenticationInfo.getPassword() != null) {
                this.getLog().debug((CharSequence)String.format(" password '%s' found in the settings.xml file", "********"));
                return authenticationInfo.getPassword();
            }
            this.getLog().warn((CharSequence)String.format("In settings.xml no password was found for server element '%s'. Does the element exist? Using default password", this.server));
            return null;
        }
        return this.password;
    }
}

