/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.maven;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import com.xebialabs.deployit.booter.remote.BooterConfig;
import com.xebialabs.deployit.booter.remote.Proxies;
import com.xebialabs.deployit.booter.remote.RemoteBooter;
import com.xebialabs.deployit.engine.api.PackageService;
import com.xebialabs.deployit.engine.api.dto.FileUpload;
import com.xebialabs.deployit.maven.MavenContainer;
import com.xebialabs.deployit.maven.MavenDeployable;
import com.xebialabs.deployit.maven.MavenDeployed;
import com.xebialabs.deployit.maven.helper.DeploymentHelper;
import com.xebialabs.deployit.maven.helper.DeploymentLogger;
import com.xebialabs.deployit.maven.packager.MavenDarPackager;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.wagon.authentication.AuthenticationInfo;

public abstract class AbstractDeployitMojo
extends AbstractMojo {
    protected MavenProject project;
    protected String mainArtifactName;
    protected boolean skipMode;
    protected String orchestrator;
    protected boolean testMode;
    protected boolean failIfNoStepsAreGenerated;
    protected String serverAddress;
    protected int port;
    protected String username;
    protected String password;
    private String context;
    private String server;
    protected boolean secured;
    protected String environmentId;
    protected List<MavenDeployed> deployeds;
    protected boolean explicitDeployeds;
    protected List<MavenDeployable> deployables = Lists.newArrayList();
    protected List<MavenContainer> environment;
    protected boolean timestampedVersion;
    protected boolean deletePreviouslyDeployedDar;
    protected boolean generateDeployedOnUpgrade;
    protected boolean cancelTaskOnError;
    private MavenDarPackager packager;
    private DeploymentHelper deploymentHelper;
    private WagonManager wagonManager;

    protected ConfigurationItem importDar() throws MojoExecutionException {
        PackageService packageService = Proxies.getPackageService();
        String version = this.project.getArtifactId() + "/" + this.project.getVersion();
        if (packageService.list().contains(version)) {
            throw new MojoExecutionException("Version [" + version + "] is already present on the server");
        }
        File darFile = this.getPackager().perform();
        this.getLog().info((CharSequence)("Importing dar file " + darFile.getAbsolutePath()));
        InputSupplier iss = Files.newInputStreamSupplier((File)darFile);
        try {
            FileUpload fileUpload = new FileUpload();
            fileUpload.setFileData((InputStream)iss.getInput());
            return packageService.upload(darFile.getName(), fileUpload);
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Problem with reading dar archive.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    MavenDarPackager getPackager() {
        if (this.packager == null) {
            this.packager = new MavenDarPackager(this.project, this.getLog(), this.timestampedVersion || this.isSnapshotVersion());
            if (this.deployables.isEmpty()) {
                this.addMainArtifact();
            }
            this.packager.addDeployables(Lists.transform(this.deployables, (Function)new Function<MavenDeployable, MavenDeployable>(){

                public MavenDeployable apply(MavenDeployable input) {
                    input.setProject(AbstractDeployitMojo.this.project);
                    return input;
                }
            }));
        }
        return this.packager;
    }

    private void addMainArtifact() {
        try {
            MavenDeployable mainArtifactDeployable = this.generateMainDeployable();
            if (mainArtifactDeployable != null) {
                this.deployables.add(mainArtifactDeployable);
            }
        }
        catch (MojoExecutionException e) {
            e.printStackTrace();
        }
    }

    private MavenDeployable generateMainDeployable() throws MojoExecutionException {
        String ciType;
        String packaging = this.project.getPackaging();
        if (packaging.equalsIgnoreCase("dar") || packaging.equalsIgnoreCase("pom")) {
            this.getLog().debug((CharSequence)("No main artifact for this packaging " + packaging));
            return null;
        }
        if (packaging.equalsIgnoreCase("war")) {
            ciType = "jee.War";
        } else if (packaging.equalsIgnoreCase("ear")) {
            ciType = "jee.Ear";
        } else {
            this.getLog().error((CharSequence)"Unsupported pom packaging type. You must supply the deployable definition for the main artifact.");
            return null;
        }
        MavenDeployable mainArtifact = new MavenDeployable();
        mainArtifact.setType(ciType);
        mainArtifact.setGroupId(this.project.getGroupId());
        mainArtifact.setArtifactId(this.mainArtifactName);
        File file = this.project.getArtifact().getFile();
        if (file == null) {
            throw new MojoExecutionException("Cannot automatically discover main artifact file location. You must supply the deployable definition for the main artifact.");
        }
        mainArtifact.setLocation(file);
        return mainArtifact;
    }

    private boolean isSnapshotVersion() {
        return this.project.getVersion().contains("SNAPSHOT");
    }

    protected String getUsername() {
        if (this.username == null) {
            this.getLog().debug((CharSequence)("No username defined in pom.xml and no system property defined either. Trying to look up username in settings.xml under server element " + this.server));
            AuthenticationInfo authenticationInfo = this.wagonManager.getAuthenticationInfo(this.server);
            if (authenticationInfo == null) {
                this.getLog().warn((CharSequence)String.format("In settings.xml server element '%s' was not defined. Using default username.", this.server));
                return null;
            }
            if (authenticationInfo.getUserName() != null) {
                this.getLog().debug((CharSequence)String.format(" username '%s' found in the settings.xml file", authenticationInfo.getUserName()));
                return authenticationInfo.getUserName();
            }
            this.getLog().warn((CharSequence)String.format("In settings.xml no username was found for server element '%s'. Does the element exist? Using default username.", this.server));
            return null;
        }
        return this.username;
    }

    protected String getPassword() {
        if (this.password == null) {
            this.getLog().debug((CharSequence)("No password defined in pom.xml and no system property defined either. Trying to look up password in settings.xml under server element " + this.server));
            AuthenticationInfo authenticationInfo = this.wagonManager.getAuthenticationInfo(this.server);
            if (authenticationInfo == null) {
                this.getLog().warn((CharSequence)String.format("In settings.xml server element '%s' was not defined. Using default password.", this.server));
                return null;
            }
            if (authenticationInfo.getPassword() != null) {
                this.getLog().debug((CharSequence)String.format(" password '%s' found in the settings.xml file", "********"));
                return authenticationInfo.getPassword();
            }
            this.getLog().warn((CharSequence)String.format("In settings.xml no password was found for server element '%s'. Does the element exist? Using default password", this.server));
            return null;
        }
        return this.password;
    }

    protected void boot() {
        RemoteBooter.boot((BooterConfig)BooterConfig.builder().withProtocol(this.secured ? BooterConfig.Protocol.HTTPS : BooterConfig.Protocol.HTTP).withCredentials(this.getUsername(), this.getPassword()).withHost(this.serverAddress).withPort(this.port).build());
    }

    protected void shutdown() {
        RemoteBooter.shutdown();
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
    }

    public void setEnvironment(List<MavenContainer> environment) {
        this.environment = environment;
    }

    public void setMainArtifactName(String mainArtifactName) {
        this.mainArtifactName = mainArtifactName;
    }

    public void setDeletePreviouslyDeployedDar(boolean deletePreviouslyDeployedDar) {
        this.deletePreviouslyDeployedDar = deletePreviouslyDeployedDar;
    }

    public void setExplicitDeployeds(boolean explicitDeployeds) {
        this.explicitDeployeds = explicitDeployeds;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setDeploymentHelper(DeploymentHelper deploymentHelper) {
        this.deploymentHelper = deploymentHelper;
    }

    protected DeploymentHelper getDeploymentHelper() {
        if (this.deploymentHelper == null) {
            this.deploymentHelper = new DeploymentHelper(new DeploymentLogger(){

                @Override
                public void debug(String s) {
                    AbstractDeployitMojo.this.getLog().debug((CharSequence)s);
                }

                @Override
                public void info(String s) {
                    AbstractDeployitMojo.this.getLog().info((CharSequence)s);
                }

                @Override
                public void warn(String s) {
                    AbstractDeployitMojo.this.getLog().warn((CharSequence)s);
                }

                @Override
                public void error(String s) {
                    AbstractDeployitMojo.this.getLog().error((CharSequence)s);
                }
            });
        }
        return this.deploymentHelper;
    }

    public void setTestMode(boolean testMode) {
        this.testMode = testMode;
    }

    protected boolean hasDeployeds() {
        return this.deployeds != null && this.deployeds.size() > 0;
    }

    public void setGenerateDeployedOnUpgrade(boolean generateDeployedOnUpgrade) {
        this.generateDeployedOnUpgrade = generateDeployedOnUpgrade;
    }
}

