/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.maven;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;

public class MavenDeployable {
    protected String name;
    protected String type;
    protected File location;
    protected String entryName;
    protected final Map<String, String> values = Maps.newHashMap();
    protected final List<String> tags = Lists.newArrayList();
    private String groupId;
    private String artifactId;
    private String classifier;
    private MavenProject project;

    public MavenDeployable() {
    }

    public MavenDeployable(String name, String type) {
        this(name, type, null);
    }

    public MavenDeployable(String name, String type, File location) {
        this.name = name;
        this.type = type;
        this.location = location;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Map<String, String> getValues() {
        return this.values;
    }

    public void setLocation(File location) {
        this.location = location;
        if (this.entryName == null) {
            this.entryName = location.getName();
        }
    }

    public String getEntryName() {
        if (Strings.isNullOrEmpty((String)this.entryName)) {
            this.entryName = this.getLocation() == null ? this.name : this.getLocation().getName();
        }
        return this.entryName;
    }

    public void setEntryName(String entryName) {
        this.entryName = entryName;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void addTag(String tag) {
        this.tags.add(tag);
    }

    public void addValue(String name, String value) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)value, (Object)String.format("null value for %s", name));
        try {
            if ("location".equals(name)) {
                this.setLocation(new File(value));
            } else {
                Field declaredField = this.getField(name);
                declaredField.set(this, value);
            }
        }
        catch (NoSuchFieldException e) {
            this.values.put("CI-" + name, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(String.format("Cannot set %s value on field %s", name, value), e);
        }
    }

    public String getId() {
        return Joiner.on((String)":").skipNulls().join((Object)(Strings.isNullOrEmpty((String)this.groupId) ? this.project.getGroupId() : this.groupId), (Object)Strings.emptyToNull((String)this.classifier), new Object[]{this.artifactId});
    }

    private Field getField(String name) throws NoSuchFieldException {
        try {
            return MavenDeployable.class.getDeclaredField(name);
        }
        catch (NoSuchFieldException nsfe) {
            return MavenDeployable.class.getDeclaredField(name);
        }
    }

    public String getName() {
        return Strings.isNullOrEmpty((String)this.name) ? this.artifactId : this.name;
    }

    public File getLocation() {
        if (this.location != null) {
            if (this.location.isAbsolute()) {
                return this.location;
            }
            return new File(this.project.getBasedir(), this.location.getPath());
        }
        if (this.isMavenArtifact()) {
            ImmutableMap idToArtifact;
            String id = this.getId();
            Artifact artifact = (Artifact)this.project.getArtifactMap().get(id);
            Set dependencyArtifacts = this.project.getDependencyArtifacts();
            if (dependencyArtifacts != null && (idToArtifact = Maps.uniqueIndex((Iterable)dependencyArtifacts, (Function)new Function<Artifact, String>(){

                public String apply(Artifact input) {
                    return Joiner.on((String)":").skipNulls().join((Object)input.getGroupId(), (Object)Strings.emptyToNull((String)input.getClassifier()), new Object[]{input.getArtifactId()});
                }
            })).containsKey(this.getId())) {
                artifact = (Artifact)idToArtifact.get(this.getId());
            }
            if (artifact == null && this.artifactId.equals(this.project.getArtifactId())) {
                artifact = this.project.getArtifact();
            }
            if (artifact == null) {
                throw new IllegalStateException(String.format("The artifact %s not found in the project dependencies %s", this.getId(), dependencyArtifacts));
            }
            File file = artifact.getFile();
            if (file == null) {
                throw new IllegalStateException(String.format("Associated file of %s is empty", artifact));
            }
            return file;
        }
        return null;
    }

    private boolean isMavenArtifact() {
        return !Strings.isNullOrEmpty((String)this.groupId) || !Strings.isNullOrEmpty((String)this.artifactId);
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public String toString() {
        return "MavenDeployable{artifactId='" + this.artifactId + '\'' + ", classifier='" + this.classifier + '\'' + ", groupId='" + this.groupId + '\'' + "} " + super.toString();
    }

    public String getArtifactId() {
        return this.artifactId;
    }
}

