/*
 * This file is part of Maven Deployit plugin.
 *
 * Maven Deployit plugin is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Maven Deployit plugin is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Maven Deployit plugin.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.xebialabs.deployit.maven;


import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;

import java.util.Map;
import java.util.Set;

import static java.lang.String.format;

public class MavenContainer extends Container {

    protected String type;
    protected String id;
    protected boolean addedToEnvironment = true;

    final protected Map<String, Object> properties = Maps.newHashMap();


    public String getType() {
        return type;
    }

    public String getId() {
        if (id == null) {
            throw new IllegalStateException("id cannot be null");
        }
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setType(String type) {
        this.type = type;
    }


    public boolean isAddedToEnvironment() {
        return addedToEnvironment;
    }

    public void setAddedToEnvironment(boolean addedToEnvironment) {
        this.addedToEnvironment = addedToEnvironment;
    }

    public Map<String, Object> getProperties() {
        return properties;
    }

    public String toString() {
        final Set<Map.Entry<String, Object>> entries = getProperties().entrySet();
        String properties = "{";
        boolean first = false;
        for (Map.Entry<String, Object> e : entries) {
            properties += (first ? "," : "") + "\"" + e.getKey() + "\":\"" + e.getValue() + "\"";
            first = true;
        }
        properties += "}";

        return format("repository.create(\"%s\",factory.configurationItem(\"%s\", %s))", getId(), getType(), properties);
    }

    public void addParameter(String name, Object value) {
        if ("addedToEnvironment".equals(name)) {
            addedToEnvironment = Boolean.parseBoolean(value.toString());
            return;
        }

        if ("type".equals(name)) {
            //TODO: add a check 'type contains at least a dot'
            setType(value.toString());
            return;
        }

        if ("id".equals(name)) {
            id = value.toString();
            return;
        }
        properties.put(name, value);
    }

    public ConfigurationItem asConfigurationItem() {
        BaseConfigurationItem ci = new BaseConfigurationItem();
        ci.setType(Type.valueOf(getType()));
        ci.setId(getId());

        for (Map.Entry<String, Object> e : getProperties().entrySet()) {
            if ("addedToEnvironment".equals(e.getKey())) {
                continue;
            }
            ci.setProperty(e.getKey(), e.getValue());
        }

        return ci;
    }
}
