/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.maven.packager;

import com.google.common.io.Closeables;
import com.xebialabs.deployit.maven.MavenDeployable;
import com.xebialabs.deployit.maven.converter.Files;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class MavenDarPackager {
    private final Log log;
    private final Manifest manifest = new Manifest();
    private final File workingDirectory;
    private final File darFile;

    public MavenDarPackager(MavenProject project, String applicationName, boolean timestampedVersion, Log log) {
        File targetDir = new File(project.getBuild().getDirectory());
        this.log = log;
        this.workingDirectory = new File(targetDir, "deployit-working-dir");
        this.darFile = new File(targetDir, String.format("%s-%s.dar", project.getArtifactId(), project.getVersion()));
        Attributes mainAttributes = this.manifest.getMainAttributes();
        mainAttributes.putValue("Manifest-Version", "1.0");
        mainAttributes.putValue("Deployit-Package-Format-Version", "1.3");
        mainAttributes.putValue("CI-Application", applicationName);
        mainAttributes.putValue("CI-Version", MavenDarPackager.getCIVersion(project, timestampedVersion));
    }

    public void addDeployable(MavenDeployable deployable) {
        this.log.debug((CharSequence)("Add deployable " + deployable));
        Map<String, Attributes> entries = this.manifest.getEntries();
        Attributes attributes = new Attributes();
        attributes.putValue("CI-Type", deployable.getType());
        attributes.putValue("CI-Name", deployable.getName());
        for (Map.Entry<String, String> me : deployable.getValues().entrySet()) {
            attributes.putValue(me.getKey(), me.getValue());
        }
        entries.put(deployable.getEntryName(), attributes);
        if (!deployable.getTags().isEmpty()) {
            int idx = 0;
            for (String tag : deployable.getTags()) {
                attributes.putValue("CI-tags-EntryValue-" + idx, tag);
                ++idx;
            }
        }
        if (deployable.getLocation() != null) {
            File location = deployable.getLocation();
            if (location.isFile()) {
                this.log.debug((CharSequence)String.format(" copy file %s to %s", location, this.workingDirectory));
                Files.copyFileTo(location, this.workingDirectory);
            } else {
                this.log.debug((CharSequence)String.format(" copy dir  %s to %s", location, this.workingDirectory));
                Files.copyDirectoryTo(location, this.workingDirectory);
            }
            if (!location.getName().equals(deployable.getEntryName())) {
                File oldName = new File(this.workingDirectory, location.getName());
                File newName = new File(this.workingDirectory, deployable.getEntryName());
                this.log.debug((CharSequence)String.format(" rename %s to %s", oldName, newName));
                Files.rename(oldName, newName);
            }
        }
    }

    public void addDeployables(MavenDeployable ... deployables) {
        for (MavenDeployable deployable : deployables) {
            this.addDeployable(deployable);
        }
    }

    public void addDeployables(Collection<? extends MavenDeployable> deployables) {
        for (MavenDeployable mavenDeployable : deployables) {
            this.addDeployable(mavenDeployable);
        }
    }

    public File perform() {
        if (!this.darFile.exists()) {
            this.log.debug((CharSequence)(" create the jar " + this.darFile));
            Files.jar(this.darFile, this.workingDirectory, this.generateManifestFile());
        }
        return this.darFile;
    }

    private File generateManifestFile() {
        File meta_inf = new File(this.workingDirectory, "META-INF");
        meta_inf.mkdirs();
        File manifestFile = new File(meta_inf, "MANIFEST.MF");
        this.log.info((CharSequence)("Generate manifest file " + manifestFile.getAbsolutePath()));
        FileOutputStream fos = null;
        try {
            this.dumpManifest();
            fos = new FileOutputStream(manifestFile);
            this.manifest.write(fos);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("generation of the manifest file failed", e);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(fos);
                throw throwable;
            }
        }
        Closeables.closeQuietly((Closeable)fos);
        return manifestFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpManifest() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.manifest.write(baos);
        }
        finally {
            Closeables.closeQuietly((Closeable)baos);
        }
        this.log.debug((CharSequence)new String(baos.toByteArray()));
    }

    private static String getCIVersion(MavenProject project, boolean timestampedVersion) {
        String ciVersion = project.getVersion();
        if (timestampedVersion) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd-HHmmss");
            ciVersion = project.getVersion() + "-" + dateFormat.format(System.currentTimeMillis());
            ciVersion = ciVersion.replace("-SNAPSHOT", "");
        }
        return ciVersion;
    }
}

