/*
 * This file is part of Maven Deployit plugin.
 *
 * Maven Deployit plugin is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Maven Deployit plugin is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Maven Deployit plugin.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.xebialabs.deployit.maven;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

import com.xebialabs.deployit.engine.api.DeploymentService;
import com.xebialabs.deployit.engine.api.dto.Deployment;

/**
 * Clean (Undeploy) the target environment.
 *
 * @author Benoit Moussaud
 * @goal clean
 * @phase post-integration-test
 * @configurator override
 */
public class CleanMojo extends AbstractDeployitMojo {
    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        getLog().info("deployit:clean");
        boot();

        try {
            DeploymentService deploymentService = communicator.getProxies().getDeploymentService();

            // since packager creates name of the application we should use it to retrieve name from it also
            applicationName = getPackager().getApplicationName();
            Deployment undeployment = deploymentService.prepareUndeploy(environmentId + "/" + applicationName);
            String task = deploymentService.createTask(undeployment);

            getDeploymentHelper().executeAndArchiveTask(task);

            getLog().info("end of deployit:clean.");
        } finally {
            shutdown();
        }
    }

}
