/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.maven.converter;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.maven.MavenDeployable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.configuration.PlexusConfiguration;

public class MavenDeployableConverter {
    public static final String DEPLOYABLE = "deployable";

    public static MavenDeployable convertToDeployable(PlexusConfiguration configuration) throws ComponentConfigurationException {
        try {
            return MavenDeployableConverter.doConvertToDeployable(configuration);
        }
        catch (Exception e) {
            throw new ComponentConfigurationException((Throwable)e);
        }
    }

    private static MavenDeployable doConvertToDeployable(PlexusConfiguration configuration) {
        if (configuration.getName().equals(DEPLOYABLE)) {
            return MavenDeployableConverter.doLegacyFormatConversion(configuration);
        }
        return MavenDeployableConverter.doXmlManifestFormatConversion(configuration);
    }

    private static MavenDeployable doXmlManifestFormatConversion(PlexusConfiguration configuration) {
        MavenDeployable deployable = new MavenDeployable();
        deployable.setType(configuration.getName());
        for (String string : configuration.getAttributeNames()) {
            deployable.addValue(string, configuration.getAttribute(string));
        }
        for (String string : configuration.getChildren()) {
            String name = string.getName();
            if (string.getAttribute("ref") != null) {
                deployable.addValue(name, new MavenDeployable.CiRefProperty(string.getAttribute("ref")));
                continue;
            }
            if (string.getChild("ci", false) != null) {
                deployable.addValue(name, MavenDeployableConverter.convertCollectionOfCiReferences(string.getChildren()));
                continue;
            }
            if (string.getChild("value", false) != null) {
                deployable.addValue(name, MavenDeployableConverter.convertCollectionOfString(string.getChildren()));
                continue;
            }
            if (string.getChild("entry", false) != null) {
                deployable.addValue(name, MavenDeployableConverter.convertMapOfStringString(string.getChildren()));
                continue;
            }
            if ("tags".equals(name)) {
                deployable.addValue(name, MavenDeployableConverter.convertCollectionOfString(string.getChildren()));
                continue;
            }
            if (string.getChildCount() > 0) {
                deployable.addValue(name, MavenDeployableConverter.convertEmbeddeds(string.getChildren()));
                continue;
            }
            deployable.addValue(name, string.getValue());
        }
        return deployable;
    }

    private static MavenDeployable doLegacyFormatConversion(PlexusConfiguration configuration) {
        MavenDeployable deployable = new MavenDeployable();
        for (PlexusConfiguration propertyConfiguration : configuration.getChildren()) {
            PlexusConfiguration[] entries;
            PlexusConfiguration[] values;
            String name = propertyConfiguration.getName();
            if (propertyConfiguration.getChild("list", false) != null) {
                values = propertyConfiguration.getChild("list").getChildren();
                if (values.length <= 0) continue;
                if (values[0].getName().equals("value")) {
                    deployable.addValue(name, MavenDeployableConverter.convertLegacyCollectionOfString("value", values));
                    continue;
                }
                deployable.addValue(name, MavenDeployableConverter.convertCollectionOfCiReferences(values));
                continue;
            }
            if (propertyConfiguration.getChild("set", false) != null) {
                values = propertyConfiguration.getChild("set").getChildren();
                if (values.length <= 0) continue;
                if (values[0].getName().equals("value")) {
                    deployable.addValue(name, MavenDeployableConverter.convertLegacyCollectionOfString("value", values));
                    continue;
                }
                deployable.addValue(name, MavenDeployableConverter.convertCollectionOfCiReferences(values));
                continue;
            }
            if (propertyConfiguration.getChild("map", false) != null) {
                entries = propertyConfiguration.getChild("map").getChildren();
                deployable.addValue(name, MavenDeployableConverter.convertLegacyMapOfStringString(entries));
                continue;
            }
            if (propertyConfiguration.getName().equals("tags")) {
                entries = propertyConfiguration.getChildren();
                deployable.addValue(name, MavenDeployableConverter.convertLegacyCollectionOfString("tag", entries));
                continue;
            }
            String c = propertyConfiguration.getValue();
            deployable.addValue(name, c);
        }
        return deployable;
    }

    private static List<MavenDeployable.CiRefProperty> convertCollectionOfCiReferences(PlexusConfiguration[] ciRefConfig) {
        ArrayList refs = Lists.newArrayList();
        for (PlexusConfiguration configuration : ciRefConfig) {
            if (!configuration.getName().equals("ci")) continue;
            refs.add(new MavenDeployable.CiRefProperty(configuration.getAttribute("ref")));
        }
        return refs;
    }

    private static List<String> convertCollectionOfString(PlexusConfiguration[] valueConfigs) {
        ArrayList values = Lists.newArrayList();
        for (PlexusConfiguration configuration : valueConfigs) {
            if (!configuration.getName().equals("value")) continue;
            values.add(configuration.getValue());
        }
        return values;
    }

    private static Map<String, String> convertMapOfStringString(PlexusConfiguration[] valueConfigs) {
        HashMap values = Maps.newHashMap();
        for (PlexusConfiguration configuration : valueConfigs) {
            if (!configuration.getName().equals("entry")) continue;
            values.put(configuration.getAttribute("key"), configuration.getValue());
        }
        return values;
    }

    private static List<MavenDeployable> convertEmbeddeds(PlexusConfiguration[] valueConfigs) {
        ArrayList values = Lists.newArrayList();
        for (PlexusConfiguration configuration : valueConfigs) {
            values.add(MavenDeployableConverter.doConvertToDeployable(configuration));
        }
        return values;
    }

    private static List<String> convertLegacyCollectionOfString(String xmlElementName, PlexusConfiguration[] valueConfigs) {
        ArrayList values = Lists.newArrayList();
        for (PlexusConfiguration configuration : valueConfigs) {
            if (!configuration.getName().equals(xmlElementName)) continue;
            values.add(configuration.getValue());
        }
        return values;
    }

    private static Map<String, String> convertLegacyMapOfStringString(PlexusConfiguration[] valueConfigs) {
        HashMap values = Maps.newHashMap();
        for (PlexusConfiguration configuration : valueConfigs) {
            values.put(configuration.getName(), configuration.getValue());
        }
        return values;
    }
}

