/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.osb.ci;

import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.wls.ci.WlsDomain;
import java.util.ArrayList;

@ConfigurationItem(description="Oracle Service Bus Domain")
public class OsbDomain
extends WlsDomain {
    @ConfigurationItemProperty(required=true, description="The location of the Oracle Service Bus.", size=ConfigurationItemProperty.Size.LARGE)
    private String osbHome;

    public String getOsbHome() {
        return this.osbHome;
    }

    public void setOsbHome(String osbHome) {
        this.osbHome = osbHome;
    }

    public int executeWlstJythonScript(CommandExecutionCallbackHandler handler, HostSession s, String scriptPath, String ... args) {
        String filesep = this.getActiveHost().getOperatingSystemFamily().getFileSeparator();
        String pathsep = this.getActiveHost().getOperatingSystemFamily().getPathSeparator();
        String wlstFilePath = this.getWlJavaHome() + filesep + "bin" + filesep + "java";
        String weblogicJarFilePath = this.getWlHome() + filesep + "server" + filesep + "lib" + filesep + "weblogic.jar";
        StringBuffer classPath = new StringBuffer();
        String pathSeparator = this.getActiveHost().getPathSeparator();
        classPath.append(weblogicJarFilePath).append(pathSeparator);
        classPath.append(this.getOsbHome() + filesep + "lib" + filesep + "sb-kernel-api.jar" + pathsep);
        classPath.append(this.getOsbHome() + filesep + ".." + filesep + "modules" + filesep + "com.bea.common.configfwk_1.1.0.0.jar" + pathsep);
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(wlstFilePath);
        cmd.add("-classpath");
        cmd.add(classPath.toString());
        cmd.add("weblogic.WLST");
        cmd.add("-i");
        cmd.add(scriptPath);
        for (String arg : args) {
            cmd.add(arg);
        }
        String[] cmdArray = cmd.toArray(new String[cmd.size()]);
        return s.execute(handler, cmdArray);
    }
}

