/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.reports;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.core.rest.api.SearchParameterFactory;
import com.xebialabs.deployit.repository.ConfigurationItemEntity;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.task.Task;
import com.xebialabs.deployit.task.TaskRegistry;
import java.util.ArrayList;
import java.util.List;

public class DeploymentsForEnvironmentReport {
    private RepositoryService repositoryService;
    private TaskRegistry taskRegistry;

    public DeploymentsForEnvironmentReport(RepositoryService repositoryService, TaskRegistry taskRegistry) {
        this.repositoryService = repositoryService;
        this.taskRegistry = taskRegistry;
    }

    public Report report(String environment, Date date) {
        Report report = new Report();
        ArrayList values = Lists.newArrayList();
        SearchParameters searchParams = SearchParameterFactory.createSearchParam(Deployment.class.getName(), false, 0L, -1L, values, environment, "");
        List deployments = this.repositoryService.listEntities(searchParams);
        for (ConfigurationItemEntity deployment : deployments) {
            Task task;
            if (deployment.getCreatingTaskId() == null || !(task = this.taskRegistry.getTask(deployment.getCreatingTaskId())).getCompletionDate().before(date.getCalendar())) continue;
            Report.ReportLine reportLine = report.addLine();
            ConfigurationItemEntity deploymentPackage = (ConfigurationItemEntity)this.repositoryService.read((String)deployment.getValue("source"));
            String applicationId = deploymentPackage.getValue("application").toString();
            reportLine.addValue("application", (Object)applicationId.substring(applicationId.indexOf("/") + 1));
            reportLine.addValue("version", deploymentPackage.getValue("version"));
            reportLine.addValue("user", (Object)task.getOwner());
            reportLine.addValue("date", (Object)new Date(task.getCompletionDate(), "yyyy-MM-dd'T'HH:mm:ss.SSSZ").toString());
        }
        return report;
    }
}

