/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.key.passwd.swing;

import de.schlichtherle.key.passwd.swing.AuthenticationPanel;
import de.schlichtherle.key.passwd.swing.Feedback;
import de.schlichtherle.key.passwd.swing.PromptingKeyProviderUI;
import de.schlichtherle.swing.EnhancedPanel;
import de.schlichtherle.swing.event.PanelEvent;
import de.schlichtherle.swing.event.PanelListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class OpenKeyPanel
extends EnhancedPanel {
    private static final String CLASS_NAME = "de.schlichtherle.key.passwd.swing.OpenKeyPanel";
    private static final ResourceBundle resources = ResourceBundle.getBundle("de.schlichtherle.key.passwd.swing.OpenKeyPanel");
    private final Color defaultForeground;
    private JComponent extraDataUI;
    private Feedback feedback;
    private AuthenticationPanel authenticationPanel;
    private final JCheckBox changeKey = new JCheckBox();
    private JLabel error;
    private JPasswordField passwd;
    private JLabel passwdLabel;
    private EnhancedPanel passwdPanel;
    private JTextPane resourceID;

    public OpenKeyPanel() {
        this.initComponents();
        DocumentListener dl = new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                OpenKeyPanel.this.setError(null);
            }

            public void removeUpdate(DocumentEvent e) {
                OpenKeyPanel.this.setError(null);
            }

            public void changedUpdate(DocumentEvent e) {
                OpenKeyPanel.this.setError(null);
            }
        };
        this.passwd.getDocument().addDocumentListener(dl);
        this.authenticationPanel.getKeyFileDocument().addDocumentListener(dl);
        this.defaultForeground = this.resourceID.getForeground();
    }

    private Font getBoldFont() {
        return this.resourceID.getFont().deriveFont(1);
    }

    public void setResourceID(String resourceID) {
        String lastResourceID = PromptingKeyProviderUI.lastResourceID;
        if (!lastResourceID.equals(resourceID) && !"".equals(lastResourceID)) {
            this.resourceID.setForeground(Color.RED);
        } else {
            this.resourceID.setForeground(this.defaultForeground);
        }
        this.resourceID.setText(resourceID);
        PromptingKeyProviderUI.lastResourceID = resourceID;
    }

    public String getResourceID() {
        return this.resourceID.getText();
    }

    public String getError() {
        String error = this.error.getText();
        return error.trim().length() > 0 ? error : null;
    }

    public void setError(String error) {
        this.error.setText(error != null ? error : " ");
    }

    public Object getOpenKey() {
        switch (this.authenticationPanel.getAuthenticationMethod()) {
            case 0: {
                return this.passwd.getPassword();
            }
            case 1: {
                String keyFilePathname = this.authenticationPanel.getKeyFilePath();
                try {
                    return PromptingKeyProviderUI.readKeyFile(keyFilePathname);
                }
                catch (EOFException failure) {
                    this.setError(resources.getString("keyFile.eofException"));
                    return null;
                }
                catch (FileNotFoundException failure) {
                    this.setError(resources.getString("keyFile.fileNotFoundException"));
                    return null;
                }
                catch (IOException failure) {
                    this.setError(resources.getString("keyFile.ioException"));
                    return null;
                }
            }
        }
        throw new AssertionError((Object)"Unsupported authentication method!");
    }

    public void setKeyChangeRequested(boolean changeKeyRequested) {
        this.changeKey.setSelected(changeKeyRequested);
    }

    public boolean isKeyChangeRequested() {
        return this.changeKey.isSelected();
    }

    public JComponent getExtraDataUI() {
        return this.extraDataUI;
    }

    public void setExtraDataUI(JComponent extraDataUI) {
        if (this.extraDataUI == extraDataUI) {
            return;
        }
        if (this.extraDataUI != null) {
            this.remove(this.extraDataUI);
        }
        if (extraDataUI != null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(15, 0, 0, 0);
            this.add((Component)extraDataUI, gridBagConstraints);
        }
        this.extraDataUI = extraDataUI;
        this.revalidate();
    }

    public Feedback getFeedback() {
        return this.feedback;
    }

    public void setFeedback(Feedback feedback) {
        this.feedback = feedback;
    }

    private void initComponents() {
        this.passwdPanel = new EnhancedPanel();
        this.passwdLabel = new JLabel();
        this.passwd = new JPasswordField();
        JLabel prompt = new JLabel();
        this.resourceID = new JTextPane();
        this.authenticationPanel = new AuthenticationPanel();
        this.error = new JLabel();
        this.passwdPanel.addPanelListener(new PanelListener(){

            public void ancestorWindowShown(PanelEvent evt) {
                OpenKeyPanel.this.passwdPanelAncestorWindowShown(evt);
            }

            public void ancestorWindowHidden(PanelEvent evt) {
            }
        });
        this.passwdPanel.setLayout(new GridBagLayout());
        this.passwdLabel.setDisplayedMnemonic(resources.getString("passwd").charAt(0));
        this.passwdLabel.setLabelFor(this.passwd);
        this.passwdLabel.setText(resources.getString("passwd"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.passwdPanel.add((Component)this.passwdLabel, gridBagConstraints);
        this.passwd.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.passwdPanel.add((Component)this.passwd, gridBagConstraints);
        this.addPanelListener(new PanelListener(){

            public void ancestorWindowShown(PanelEvent evt) {
                OpenKeyPanel.this.formAncestorWindowShown(evt);
            }

            public void ancestorWindowHidden(PanelEvent evt) {
            }
        });
        this.setLayout(new GridBagLayout());
        prompt.setLabelFor(this.resourceID);
        prompt.setText(resources.getString("prompt"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)prompt, gridBagConstraints);
        this.resourceID.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.resourceID.setEditable(false);
        this.resourceID.setFont(this.getBoldFont());
        this.resourceID.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 15, 0);
        this.add((Component)this.resourceID, gridBagConstraints);
        this.authenticationPanel.setPasswdPanel(this.passwdPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        this.add((Component)this.authenticationPanel, gridBagConstraints);
        this.changeKey.setText(resources.getString("changeKey"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        this.add((Component)this.changeKey, gridBagConstraints);
        this.error.setForeground(Color.red);
        this.error.setText(" ");
        this.error.setName("error");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        this.add((Component)this.error, gridBagConstraints);
    }

    private void formAncestorWindowShown(PanelEvent evt) {
        Feedback feedback = this.getFeedback();
        if (feedback != null) {
            feedback.setPanel(this);
            feedback.run();
        }
    }

    private void passwdPanelAncestorWindowShown(PanelEvent evt) {
        final Window window = evt.getAncestorWindow();
        window.addWindowFocusListener(new WindowFocusListener(){

            public void windowGainedFocus(WindowEvent e) {
                window.removeWindowFocusListener(this);
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        if (OpenKeyPanel.this.passwd.requestFocusInWindow()) {
                            OpenKeyPanel.this.passwd.selectAll();
                        }
                    }
                });
            }

            public void windowLostFocus(WindowEvent e) {
            }
        });
    }
}

