/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.task;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.jcr.JcrCallback;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.plugin.PojoConverter;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.task.StepList;
import com.xebialabs.deployit.task.Task;
import com.xebialabs.deployit.task.TaskArchive;
import com.xebialabs.deployit.task.TaskStep;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFormatException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JcrTaskArchive
implements TaskArchive {
    private static final String LABEL = "label";
    private static final String STATE = "state";
    private static final String START_DATE = "startDate";
    private static final String COMPLETION_DATE = "completionDate";
    private static final String NR_OF_STEPS = "nrOfSteps";
    private static final String CURRENT_STEP_NR = "currentStepNr";
    private static final String OWNING_USER = "ownerUser";
    private static final String LOG = "log";
    private static final String DESCRIPTION = "description";
    private final JcrTemplate jcrTemplate;
    private final RepositoryService repositoryService;
    private final PojoConverter pojoConverter;

    @Autowired
    public JcrTaskArchive(JcrTemplate jcrTemplate, RepositoryService repositoryService, PojoConverter pojoConverter) {
        this.jcrTemplate = jcrTemplate;
        this.repositoryService = repositoryService;
        this.pojoConverter = pojoConverter;
    }

    @Override
    public void archiveTask(final Task task) {
        this.jcrTemplate.execute(new JcrCallback<String>(){

            @Override
            public String doInJcr(Session session) throws IOException, RepositoryException {
                Node tasksNode = JcrTaskArchive.this.getTasksNode(session);
                Node taskNode = tasksNode.addNode(task.getId());
                taskNode.addMixin("deployit:task");
                JcrTaskArchive.this.archiveTaskInNode(session, task, taskNode);
                session.save();
                return null;
            }
        });
    }

    private void archiveTaskInNode(Session session, Task task, Node taskNode) throws IOException, RepositoryException {
        taskNode.setProperty("$id", task.getId());
        taskNode.setProperty(LABEL, task.getLabel());
        taskNode.setProperty(STATE, task.getState().name());
        taskNode.setProperty(START_DATE, task.getStartDate());
        taskNode.setProperty(COMPLETION_DATE, task.getCompletionDate());
        taskNode.setProperty(CURRENT_STEP_NR, (long)task.getCurrentStepNr());
        taskNode.setProperty(NR_OF_STEPS, (long)task.getNrOfSteps());
        taskNode.setProperty(OWNING_USER, task.getOwner());
        for (int nr = 1; nr <= task.getNrOfSteps(); ++nr) {
            TaskStep step = task.getStep(nr);
            Node stepNode = taskNode.addNode("step" + nr);
            stepNode.setProperty(DESCRIPTION, step.getDescription());
            stepNode.setProperty(STATE, step.getState().name());
            stepNode.setProperty(START_DATE, step.getStartDate());
            stepNode.setProperty(COMPLETION_DATE, step.getCompletionDate());
            stepNode.setProperty(LOG, step.getLog());
        }
    }

    @Override
    public Task getTask(final String taskId) {
        return this.jcrTemplate.execute(new JcrCallback<Task>(){

            @Override
            public Task doInJcr(Session session) throws IOException, RepositoryException {
                try {
                    Node tasksNode = JcrTaskArchive.this.getTasksNode(session);
                    Node taskNode = tasksNode.getNode(taskId);
                    Task task = JcrTaskArchive.this.populateTaskFromNode(taskNode);
                    if (task == null) {
                        throw new NotFoundException("Cannot load task " + taskId + " because that object with that id is not a task", new Object[0]);
                    }
                    return task;
                }
                catch (PathNotFoundException exc) {
                    throw new NotFoundException("Cannot load task " + taskId + ": " + exc.toString(), new Object[]{exc});
                }
            }
        });
    }

    @Override
    public List<Task> getAllTasks() {
        return this.jcrTemplate.execute(new JcrCallback<List<Task>>(){

            @Override
            public List<Task> doInJcr(Session session) throws IOException, RepositoryException {
                try {
                    Node tasksNode = JcrTaskArchive.this.getTasksNode(session);
                    NodeIterator nodes = tasksNode.getNodes();
                    ArrayList allTasks = Lists.newArrayList();
                    while (nodes.hasNext()) {
                        Node taskNode = nodes.nextNode();
                        Task task = JcrTaskArchive.this.populateTaskFromNode(taskNode);
                        if (task == null) continue;
                        allTasks.add(task);
                    }
                    return allTasks;
                }
                catch (PathNotFoundException exc) {
                    throw new NotFoundException("Cannot load all tasks: " + exc.toString(), new Object[]{exc});
                }
            }
        });
    }

    private Task populateTaskFromNode(Node taskNode) throws RepositoryException, ValueFormatException, PathNotFoundException {
        if (!taskNode.isNodeType("deployit:task")) {
            return null;
        }
        StepList stepList = this.createStepListFromNode(taskNode);
        Task.State state = Task.State.valueOf(taskNode.getProperty(STATE).getString());
        Task task = new Task(stepList, state, this.repositoryService, this.pojoConverter, this.pojoConverter.getContext());
        task.setId(taskNode.getProperty("$id").getString());
        task.setLabel(taskNode.getProperty(LABEL).getString());
        if (taskNode.hasProperty(START_DATE)) {
            task.setStartDate(taskNode.getProperty(START_DATE).getDate());
        }
        if (taskNode.hasProperty(COMPLETION_DATE)) {
            task.setCompletionDate(taskNode.getProperty(COMPLETION_DATE).getDate());
        }
        if (taskNode.hasProperty(OWNING_USER)) {
            task.setOwner(taskNode.getProperty(OWNING_USER).getString());
        }
        return task;
    }

    private StepList createStepListFromNode(Node taskNode) throws RepositoryException {
        int currentStepNr = (int)taskNode.getProperty(CURRENT_STEP_NR).getLong();
        int nrOfSteps = (int)taskNode.getProperty(NR_OF_STEPS).getLong();
        ArrayList steps = Lists.newArrayList();
        for (int nr = 1; nr <= nrOfSteps; ++nr) {
            Node stepNode = taskNode.getNode("step" + nr);
            steps.add(this.createStepFromNode(stepNode));
        }
        return new StepList(steps, currentStepNr);
    }

    private TaskStep createStepFromNode(Node stepNode) throws RepositoryException {
        String description = stepNode.getProperty(DESCRIPTION).getString();
        TaskStep.StepState stepState = TaskStep.StepState.valueOf(stepNode.getProperty(STATE).getString());
        TaskStep step = new TaskStep(description, stepState);
        if (stepNode.hasProperty(START_DATE)) {
            step.setStartDate(stepNode.getProperty(START_DATE).getDate());
        }
        if (stepNode.hasProperty(COMPLETION_DATE)) {
            step.setCompletionDate(stepNode.getProperty(COMPLETION_DATE).getDate());
        }
        step.setLog(stepNode.getProperty(LOG).getString());
        return step;
    }

    private Node getTasksNode(Session session) throws PathNotFoundException, RepositoryException {
        return session.getRootNode().getNode("tasks");
    }
}

