/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.task;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.task.TaskStep;
import java.util.ArrayList;
import java.util.List;

class StepList
extends ArrayList<TaskStep> {
    private volatile int currentStepNr;

    StepList(List<? extends Step> steps) {
        super(new ArrayList(Collections2.transform(steps, (Function)new Function<Step, TaskStep>(){

            public TaskStep apply(Step from) {
                return new TaskStep(from);
            }
        })));
        this.currentStepNr = 0;
    }

    StepList(List<TaskStep> steps, int currentStepNr) {
        super(steps);
        this.currentStepNr = currentStepNr;
    }

    public int getNrOfSteps() {
        return this.size();
    }

    public int getCurrentStepNr() {
        return this.currentStepNr;
    }

    public TaskStep getStep(int stepNr) {
        if (stepNr < 1 || stepNr > this.getNrOfSteps()) {
            throw new IllegalArgumentException(stepNr + " is not a valid step number");
        }
        return (TaskStep)this.get(stepNr - 1);
    }

    public TaskStep getNextStep() {
        return this.getStep(++this.currentStepNr);
    }

    public boolean hasMoreSteps() {
        return this.currentStepNr < this.getNrOfSteps();
    }

    public void rollback() {
        --this.currentStepNr;
    }
}

