/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.task.deployment;

import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.mapping.Mapping;
import com.xebialabs.deployit.plugin.PojoConverter;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.security.SecurityCallback;
import com.xebialabs.deployit.security.SecurityTemplate;
import com.xebialabs.deployit.security.UsernameAndPasswordCredentials;
import com.xebialabs.deployit.task.Task;
import java.util.List;

public class UndeploymentTask
extends Task {
    private Deployment deployment;

    public UndeploymentTask(Deployment deployment, List<Step> steps, RepositoryService repositoryService, PojoConverter pojoConverter, PojoConverter.Context ... pojoConverterContexts) {
        super(steps, repositoryService, pojoConverter, pojoConverterContexts);
        this.deployment = deployment;
    }

    @Override
    public void doAfterTaskStateChangedToDone() {
        UsernameAndPasswordCredentials owner = this.getOwnerCredentials();
        SecurityTemplate.executeAs(owner.getUsername(), owner.getPassword(), new SecurityCallback<Object>(){

            @Override
            public Object doAs() {
                UndeploymentTask.this.repositoryService.delete(UndeploymentTask.this.deployment.getLabel());
                for (Mapping mapping : UndeploymentTask.this.deployment.getMappings()) {
                    UndeploymentTask.this.repositoryService.delete(mapping.getLabel());
                }
                return null;
            }
        });
    }
}

