/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.step;

import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostFileUtils;
import com.xebialabs.deployit.hostsession.HostSession;

public class HostConnectionStep
implements Step {
    protected final Host host;

    public HostConnectionStep(Host host) {
        this.host = host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(StepExecutionContext ctx) {
        try {
            HostSession rhs = this.host.getHostSession();
            try {
                HostFile fileToUpload = this.uploadFile(rhs);
                this.tryCanGetFilePermissions(rhs, fileToUpload);
            }
            finally {
                rhs.close();
            }
        }
        catch (Exception exc) {
            ctx.logError("Connection test to host " + this.host + " failed. Please check address, username and password", exc);
            return false;
        }
        ctx.logOutput("Connection test to host " + this.host + " succeeded");
        return true;
    }

    private HostFile uploadFile(HostSession rhs) {
        HostFile fileToUpload = rhs.getTempFile("hostconnection-remote", ".txt");
        HostFileUtils.putStringToHostFile("Contents of host connection test file", fileToUpload);
        return fileToUpload;
    }

    private void tryCanGetFilePermissions(HostSession rhs, HostFile fileToUpload) {
        HostFile filesJustUploadedNotAsATempFile = rhs.getFile(fileToUpload.getPath());
        if (!filesJustUploadedNotAsATempFile.canRead()) {
            throw new RuntimeException("Cannot check read permission for file just uploaded");
        }
    }

    public String getDescription() {
        return "Test connection to " + this.host;
    }
}

