/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli;

import com.xebialabs.deployit.cli.CliObject;
import com.xebialabs.deployit.cli.CliOptions;
import com.xebialabs.deployit.cli.Interpreter;
import com.xebialabs.deployit.cli.api.Proxies;
import com.xebialabs.deployit.cli.help.HelpScanner;
import com.xebialabs.deployit.cli.ssl.SelfSignedCertificateAcceptingSocketFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import jline.ConsoleReader;
import jline.Terminal;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.protocol.Protocol;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class Cli {
    private static final AtomicReference<Properties> properties = new AtomicReference();
    private static ConsoleReader consoleReader;
    private ScriptEngine scriptEngine;
    private CliOptions options;
    private static HttpClient httpClient;

    public Cli(CliOptions options) throws Exception {
        this.options = options;
        this.scriptEngine = this.createEngine();
        this.printBanner();
        this.initialize();
    }

    private void printBanner() {
        System.out.println("Welcome to the Deployit Jython CLI!");
        System.out.println("Type 'help' to learn about the objects you can use to interact with Deployit.");
        System.out.println();
    }

    private void initialize() throws Exception {
        Authentication credentials = this.createCredentials();
        this.setupSecureCommunications();
        httpClient = credentials.getAuthenticatingHttpClient();
        this.attemptToConnectToServer(httpClient);
        Proxies proxies = this.createAndRegisterProxies(httpClient);
        this.registerCliObjects(proxies);
    }

    private void setupSecureCommunications() {
        if (this.options.isSecured()) {
            Protocol easyhttps = new Protocol("https", new SelfSignedCertificateAcceptingSocketFactory(), 443);
            Protocol.registerProtocol("https", easyhttps);
        }
    }

    private Proxies createAndRegisterProxies(HttpClient client) {
        Proxies proxies = new Proxies(this.options, client);
        if (this.options.isExposeProxies()) {
            System.out.println("Exposing Proxies!");
            this.scriptEngine.put("proxies", proxies);
        }
        return proxies;
    }

    public static void main(String[] args) throws Exception {
        CliOptions options = CliOptions.parse(args);
        if (options == null) {
            return;
        }
        consoleReader = Cli.setupConsole();
        new Cli(options).getNewInterpreter().interpret(options);
    }

    private static ConsoleReader setupConsole() throws IOException {
        Terminal.setupTerminal();
        return new ConsoleReader();
    }

    private ScriptEngine createEngine() {
        ScriptEngineManager engineManager = new ScriptEngineManager();
        ScriptEngine jythonEngine = engineManager.getEngineByName("python");
        if (jythonEngine == null) {
            throw new IllegalStateException("Could not find the JythonEngine, is it on the classpath?");
        }
        return jythonEngine;
    }

    public Interpreter getNewInterpreter() throws ScriptException, FileNotFoundException {
        Interpreter interpreter = new Interpreter(consoleReader, this.scriptEngine);
        this.readExtensions(interpreter);
        return interpreter;
    }

    private void registerCliObjects(Proxies proxies) throws Exception {
        Reflections reflections = new Reflections("com.xebialabs", new Scanner[0]);
        Set<Class<?>> classes = reflections.getTypesAnnotatedWith(CliObject.class);
        for (Class<?> cliObject : classes) {
            Constructor<?> constructor = cliObject.getConstructor(Proxies.class);
            Object o = constructor.newInstance(proxies);
            String name = cliObject.getAnnotation(CliObject.class).name();
            this.scriptEngine.put(name, o);
        }
        HelpScanner.printHelp(classes);
    }

    public Authentication createCredentials() throws IOException {
        Authentication authentication = new Authentication();
        authentication.username = this.options.isUsernameOnCommandline() ? this.options.getUsername() : (this.deployitConfigurationFileExists() ? this.readFromProperties("cli.username") : consoleReader.readLine("username >"));
        authentication.password = this.options.isPasswordOnCommandline() ? this.options.getPassword() : (this.deployitConfigurationFileExists() ? this.readFromProperties("cli.password") : consoleReader.readLine("password >", Character.valueOf('\u0000')));
        return authentication;
    }

    private boolean deployitConfigurationFileExists() {
        return this.options.getConfigurationFile().exists();
    }

    private String readFromProperties(String key) throws IOException {
        if (properties.get() == null) {
            Properties props = new Properties();
            props.load(new FileInputStream(this.options.getConfigurationFile()));
            properties.set(props);
        }
        return properties.get().getProperty(key);
    }

    private void attemptToConnectToServer(HttpClient client) {
        String urlToConnectTo = this.options.getUrl();
        System.out.println("Connecting to the Deployit server at " + urlToConnectTo + "...");
        try {
            int responseCode = client.executeMethod(new GetMethod(urlToConnectTo + "/deployit/server/info"));
            if (responseCode != 200) {
                if (responseCode == 401 || responseCode == 403) {
                    throw new IllegalStateException("You were not authenticated correctly, did you use the correct credentials?");
                }
                throw new IllegalStateException("Could contact the server at " + urlToConnectTo + " but received an HTTP error code, " + responseCode);
            }
            System.out.println("Succesfully connected.");
        }
        catch (MalformedURLException mue) {
            throw new IllegalStateException("Could not contact the server at " + urlToConnectTo, mue);
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not contact the server at " + urlToConnectTo, e);
        }
    }

    private void readExtensions(Interpreter interpreter) throws ScriptException, FileNotFoundException {
        File[] files;
        File extensionDir = new File("ext");
        if (!extensionDir.exists() || !extensionDir.isDirectory()) {
            System.out.println("No extension directory present.");
            return;
        }
        for (File extension : files = extensionDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".py") || name.endsWith(".cli");
            }
        })) {
            System.out.println("Reading extension: " + extension);
            interpreter.evaluate(new FileReader(extension));
        }
    }

    public static HttpClient getHttpClient() {
        return httpClient;
    }

    static class Authentication {
        String username;
        String password;

        Authentication() {
        }

        HttpClient getAuthenticatingHttpClient() {
            HttpClient httpClient = new HttpClient();
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.username, this.password);
            httpClient.getState().setCredentials(AuthScope.ANY, credentials);
            httpClient.getParams().setAuthenticationPreemptive(true);
            httpClient.getParams().setConnectionManagerTimeout(10000L);
            return httpClient;
        }
    }
}

