/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.api.dto;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.core.api.dto.AbstractDTO;
import com.xebialabs.deployit.core.api.dto.Archetype;
import com.xebialabs.deployit.core.api.dto.ConfigurationItem;
import com.xebialabs.deployit.core.api.dto.Message;
import com.xebialabs.deployit.core.api.jaxb.MapAdapter;
import com.xebialabs.deployit.core.api.jaxb.MapElement;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang.ArrayUtils;

@XmlSeeAlso(value={Archetype.class, ConfigurationItem.class, MapElement.class})
public abstract class RepositoryObject
extends AbstractDTO {
    private String id;
    private String configurationItemTypeName;
    private String archetypeId;
    private Calendar lastModified;
    private Calendar overrideLastModified;
    private String creatingTaskId;
    private Map<String, Object> values = Maps.newHashMap();
    private List<Message> validations = Lists.newArrayList();

    public RepositoryObject() {
    }

    public RepositoryObject(String configurationItemTypeName) {
        this.configurationItemTypeName = configurationItemTypeName;
    }

    public RepositoryObject(String configurationItemTypeName, String ... properties) {
        this.configurationItemTypeName = configurationItemTypeName;
        this.setProperties(properties);
    }

    public RepositoryObject(String id, String configurationItemTypeName) {
        this.id = id;
        this.configurationItemTypeName = configurationItemTypeName;
    }

    @XmlElement(name="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @XmlElement(name="configuration-item-type-name")
    public String getConfigurationItemTypeName() {
        return this.configurationItemTypeName;
    }

    public void setConfigurationItemTypeName(String ciType) {
        this.configurationItemTypeName = ciType;
    }

    @XmlElement(name="archetype-id")
    public String getArchetypeId() {
        return this.archetypeId;
    }

    public void setArchetypeId(String archetypeId) {
        this.archetypeId = archetypeId;
    }

    @XmlElement(name="last-modified")
    public Calendar getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Calendar lastModified) {
        this.lastModified = lastModified;
    }

    @XmlElement(name="override-last-modified")
    public Calendar getOverrideLastModified() {
        return this.overrideLastModified;
    }

    public void setOverrideLastModified(Calendar overrideLastModified) {
        this.overrideLastModified = overrideLastModified;
    }

    @XmlElement(name="creating-task-id")
    public String getCreatingTaskId() {
        return this.creatingTaskId;
    }

    public void setCreatingTaskId(String creatingTaskId) {
        this.creatingTaskId = creatingTaskId;
    }

    @XmlJavaTypeAdapter(value=MapAdapter.class)
    public Map<String, Object> getValues() {
        return this.values;
    }

    public void setValues(Map<String, Object> values) {
        this.values = values;
    }

    public void setProperty(String propertyName, Object propertyValue) {
        this.values.put(propertyName, propertyValue);
    }

    public void addPropertyValue(String propertyName, Object propertyValue) {
        Object valueFromMap = this.values.get(propertyName);
        if (valueFromMap instanceof Collection) {
            Collection valueAsCollection = (Collection)valueFromMap;
            valueAsCollection.add(propertyValue);
        } else if (valueFromMap instanceof Object[]) {
            Object[] valueAsObject = (Object[])valueFromMap;
            ArrayUtils.add(valueAsObject, propertyValue);
        }
    }

    public void setProperties(String ... keyValuePairs) {
        for (String each : keyValuePairs) {
            if (!each.contains("=")) continue;
            String[] keyValue = each.split("=");
            this.setProperty(keyValue[0], keyValue[1]);
        }
    }

    @XmlElement(name="validations")
    public List<Message> getValidations() {
        return this.validations;
    }

    public void setValidations(List<Message> validations) {
        this.validations = validations;
    }
}

