/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.core.executors;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.core.BaseClientResponse;
import org.jboss.resteasy.client.core.SelfExpandingBufferredInputStream;
import org.jboss.resteasy.client.core.executors.HttpClientHeaderWrapper;
import org.jboss.resteasy.util.CaseInsensitiveMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApacheHttpClientExecutor
implements ClientExecutor {
    protected HttpClient httpClient;

    public ApacheHttpClientExecutor() {
        this.httpClient = new HttpClient();
    }

    public ApacheHttpClientExecutor(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public static CaseInsensitiveMap<String> extractHeaders(HttpMethodBase baseMethod) {
        CaseInsensitiveMap<String> headers = new CaseInsensitiveMap<String>();
        for (Header header : baseMethod.getResponseHeaders()) {
            headers.add(header.getName(), header.getValue());
        }
        return headers;
    }

    @Override
    public ClientRequest createRequest(String uriTemplate) {
        return new ClientRequest(uriTemplate, (ClientExecutor)this);
    }

    @Override
    public ClientRequest createRequest(UriBuilder uriBuilder) {
        return new ClientRequest(uriBuilder, (ClientExecutor)this);
    }

    @Override
    public ClientResponse execute(ClientRequest request) throws Exception {
        String uri = request.getUri();
        final HttpMethodBase httpMethod = this.createHttpMethod(uri, request.getHttpMethod());
        this.loadHttpMethod(request, httpMethod);
        int status = this.httpClient.executeMethod(httpMethod);
        BaseClientResponse response = new BaseClientResponse(new BaseClientResponse.BaseClientResponseStreamFactory(){
            InputStream stream;

            public InputStream getInputStream() throws IOException {
                if (this.stream == null) {
                    this.stream = new SelfExpandingBufferredInputStream(httpMethod.getResponseBodyAsStream());
                }
                return this.stream;
            }

            public void performReleaseConnection() {
                try {
                    httpMethod.releaseConnection();
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                try {
                    this.stream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }, this);
        response.setStatus(status);
        response.setHeaders(ApacheHttpClientExecutor.extractHeaders(httpMethod));
        response.setProviderFactory(request.getProviderFactory());
        return response;
    }

    private HttpMethodBase createHttpMethod(String url, String restVerb) {
        if ("GET".equals(restVerb)) {
            return new GetMethod(url);
        }
        if ("POST".equals(restVerb)) {
            return new PostMethod(url);
        }
        if ("DELETE".equals(restVerb)) {
            return new DeleteMethod(url);
        }
        final String verb = restVerb;
        return new PostMethod(url){

            public String getName() {
                return verb;
            }
        };
    }

    public void loadHttpMethod(ClientRequest request, HttpMethodBase httpMethod) throws Exception {
        if (httpMethod instanceof GetMethod && request.followRedirects()) {
            httpMethod.setFollowRedirects(true);
        } else {
            httpMethod.setFollowRedirects(false);
        }
        if (request.getHeaders() != null) {
            for (Map.Entry header : request.getHeaders().entrySet()) {
                List values = (List)header.getValue();
                for (String value : values) {
                    httpMethod.addRequestHeader((String)header.getKey(), value);
                }
            }
        }
        if (request.getBody() != null && !request.getFormParameters().isEmpty()) {
            throw new RuntimeException("You cannot send both form parameters and an entity body");
        }
        if (!request.getFormParameters().isEmpty()) {
            PostMethod post = (PostMethod)httpMethod;
            for (Map.Entry formParam : request.getFormParameters().entrySet()) {
                List values = (List)formParam.getValue();
                for (String value : values) {
                    post.addParameter((String)formParam.getKey(), value);
                }
            }
        }
        if (request.getBody() != null) {
            if (!(httpMethod instanceof EntityEnclosingMethod)) {
                throw new RuntimeException("A GET request cannot have a body.");
            }
            ClientRequestEntity requestEntity = new ClientRequestEntity(new HttpClientHeaderWrapper(httpMethod, request.getProviderFactory()), request);
            EntityEnclosingMethod post = (EntityEnclosingMethod)httpMethod;
            post.setRequestEntity(requestEntity);
        }
    }

    private static class ClientRequestEntity
    implements RequestEntity {
        private byte[] bytes;
        private ClientRequest request;

        public ClientRequestEntity(HttpClientHeaderWrapper wrapper, ClientRequest request) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.request = request;
            try {
                request.writeRequestBody(wrapper, baos);
                this.bytes = baos.toByteArray();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public boolean isRepeatable() {
            return true;
        }

        public void writeRequest(OutputStream outputStream) throws IOException {
            outputStream.write(this.bytes);
        }

        public long getContentLength() {
            return this.bytes.length;
        }

        public String getContentType() {
            return this.request.getBodyContentType().toString();
        }
    }
}

