/*
 * Decompiled with CFR 0.152.
 */
package com.qrmedia.commons.reflect;

import java.lang.reflect.Field;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReflectionUtils {
    public static void setValue(Object target, String propertyName, Object value) throws IllegalAccessException {
        ReflectionUtils.setPropertyValue(target, null, propertyName, value);
    }

    private static void setPropertyValue(Object target, Class<? extends Object> targetClass, String propertyName, Object value) throws IllegalAccessException {
        int separatorIndex = propertyName.indexOf(46);
        if (separatorIndex == -1) {
            ReflectionUtils.setFieldValue(target, targetClass, propertyName, value);
            return;
        }
        ReflectionUtils.setPropertyValue(ReflectionUtils.getFieldValue(target, targetClass, propertyName.substring(0, separatorIndex)), null, propertyName.substring(separatorIndex + 1), value);
    }

    private static void setFieldValue(Object target, Class<? extends Object> targetClass, String fieldName, Object value) throws IllegalAccessException {
        try {
            Field field = ReflectionUtils.getAccessibleField(target != null ? target.getClass() : targetClass, fieldName);
            field.set(target, value);
        }
        catch (Exception exception) {
            boolean instanceFieldRequested = target != null;
            throw new IllegalAccessException(String.format("Unable to set field '%s' on %s '%s' due to %s: %s", fieldName, instanceFieldRequested ? "object" : "class", instanceFieldRequested ? target : targetClass.getName(), exception.getClass().getSimpleName(), exception.getMessage()));
        }
    }

    private static Field getAccessibleField(Class<? extends Object> targetClass, String fieldName) throws SecurityException, NoSuchFieldException {
        Class<? extends Object> currentClass = targetClass;
        Field field = null;
        do {
            try {
                field = currentClass.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException exception) {
                currentClass = currentClass.getSuperclass();
            }
        } while (field == null && currentClass != null);
        if (field == null) {
            throw new NoSuchFieldException(fieldName);
        }
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        return field;
    }

    public static void setValue(Class<? extends Object> targetClass, String propertyName, Object value) throws IllegalAccessException {
        ReflectionUtils.setPropertyValue(null, targetClass, propertyName, value);
    }

    public static boolean trySetValue(Object target, String propertyName, Object value) {
        return ReflectionUtils.trySetPropertyValue(target, null, propertyName, value);
    }

    private static boolean trySetPropertyValue(Object target, Class<? extends Object> targetClass, String propertyName, Object value) {
        try {
            ReflectionUtils.setPropertyValue(target, targetClass, propertyName, value);
            return true;
        }
        catch (IllegalAccessException exception) {
            return false;
        }
    }

    public static boolean trySetValue(Class<? extends Object> targetClass, String propertyName, Object value) {
        return ReflectionUtils.trySetPropertyValue(null, targetClass, propertyName, value);
    }

    public static <T> T getValue(Object target, String propertyName) throws IllegalAccessException {
        return ReflectionUtils.getPropertyValue(target, null, propertyName);
    }

    private static <T> T getPropertyValue(Object target, Class<? extends Object> targetClass, String propertyName) throws IllegalAccessException {
        String[] fieldNames = propertyName.split("\\.");
        T value = ReflectionUtils.getFieldValue(target, targetClass, fieldNames[0]);
        int numFieldNames = fieldNames.length;
        if (numFieldNames == 1) {
            return ReflectionUtils.getFieldValue(target, targetClass, propertyName);
        }
        for (int i = 1; i < numFieldNames; ++i) {
            value = ReflectionUtils.getFieldValue(value, null, fieldNames[i]);
        }
        return value;
    }

    private static <T> T getFieldValue(Object target, Class<? extends Object> targetClass, String fieldName) throws IllegalAccessException {
        boolean instanceFieldRequested = target != null;
        try {
            return (T)ReflectionUtils.getAccessibleField(instanceFieldRequested ? target.getClass() : targetClass, fieldName).get(instanceFieldRequested ? target : null);
        }
        catch (Exception exception) {
            throw new IllegalAccessException(String.format("Unable to get value of field '%s' of %s '%s' due to %s: %s", fieldName, instanceFieldRequested ? "object" : "class", instanceFieldRequested ? target : targetClass.getName(), exception.getClass().getSimpleName(), exception.getMessage()));
        }
    }

    public static <T> T getValue(Class<? extends Object> targetClass, String propertyName) throws IllegalAccessException {
        return ReflectionUtils.getPropertyValue(null, targetClass, propertyName);
    }
}

