/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit;

import com.xebialabs.deployit.DeployitExceptionMapper;
import com.xebialabs.deployit.core.api.resteasy.http.tunnel.ResponseFactory;
import com.xebialabs.deployit.exception.DeployitException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnhandledExceptionMapper
implements ExceptionMapper<RuntimeException> {
    private static final Logger logger = LoggerFactory.getLogger(UnhandledExceptionMapper.class);

    @Override
    public Response toResponse(RuntimeException exception) {
        logger.debug("Intercepting (possibly) unhandled exception...");
        if (exception instanceof DeployitException) {
            return new DeployitExceptionMapper().toResponse((DeployitException)exception);
        }
        logger.error("Unhandled Exception: {}", exception);
        Response.ResponseBuilder builder = ResponseFactory.serverError().type("application/xml");
        builder.header("Unhandled-Exception", "true");
        builder.header("Exception-Type", exception.getClass().getName());
        builder.entity(exception.getMessage());
        return builder.build();
    }
}

