/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemDescription;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ci.Host;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@ConfigurationItem(description="A generic web server.", category="middleware")
public abstract class HttpdServer
extends BaseConfigurationItem {
    @ConfigurationItemDescription
    protected String description;
    @ConfigurationItemProperty(required=true, asContainment=true, description="Host on which the web server runs")
    protected Host host;

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Host getHost() {
        return this.host;
    }

    public void setHost(Host host) {
        this.host = host;
    }

    public static class HostAndPort {
        private static final Pattern HOST_PORT_PATTERN = Pattern.compile("(?:(\\S+|\\*)):(?:(\\d{1,5}+|\\*))");
        private final String host;
        private final String port;
        private final String filenameFriendlyHost;
        private final String filenameFriendlyPort;

        public HostAndPort(String hostAndPort) {
            Preconditions.checkArgument(hostAndPort != null, "Argument must be non-null");
            Matcher hostAndPortMatcher = HOST_PORT_PATTERN.matcher(hostAndPort);
            if (!HostAndPort.isValidHostAndPort(hostAndPortMatcher)) {
                throw new IllegalArgumentException(String.format("'%s' does not match the pattern <hostname>:<port>", hostAndPort));
            }
            this.host = hostAndPortMatcher.group(1);
            this.port = hostAndPortMatcher.group(2);
            this.filenameFriendlyHost = HostAndPort.toFilenameFriendlyName(this.host, "allhosts");
            this.filenameFriendlyPort = HostAndPort.toFilenameFriendlyName(this.port, "allports");
        }

        private static String toFilenameFriendlyName(String value, String replacement) {
            return value.equals("*") ? replacement : value;
        }

        public static boolean isValidHostAndPort(String hostAndPort) {
            if (hostAndPort == null) {
                return false;
            }
            return HostAndPort.isValidHostAndPort(HOST_PORT_PATTERN.matcher(hostAndPort));
        }

        private static boolean isValidHostAndPort(Matcher hostAndPortMatcher) {
            return hostAndPortMatcher.matches();
        }

        public String getHost() {
            return this.host;
        }

        public String getPort() {
            return this.port;
        }

        public String getFilenameFriendlyHost() {
            return this.filenameFriendlyHost;
        }

        public String getFilenameFriendlyPort() {
            return this.filenameFriendlyPort;
        }
    }
}

