/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.core.api.ImportablePackageProxy;
import com.xebialabs.deployit.core.api.dto.FileUpload;
import com.xebialabs.deployit.core.api.dto.ImportablePackages;
import com.xebialabs.deployit.core.api.dto.RepositoryObject;
import com.xebialabs.deployit.core.api.resteasy.http.tunnel.ResponseFactory;
import com.xebialabs.deployit.core.rest.api.DtoConverter;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.repository.RepositoryObjectEntity;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.service.importer.ImporterService;
import com.xebialabs.deployit.service.importer.PackageInfo;
import java.util.List;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class ImportablePackageResource
extends AbstractSecuredResource
implements ImportablePackageProxy {
    @Autowired
    private ImporterService importerService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private DtoConverter dtoConverter;
    private static final Logger logger = LoggerFactory.getLogger(ImportablePackageResource.class);

    @Override
    public Response list() {
        List<String> files = this.importerService.list();
        return ResponseFactory.ok(new ImportablePackages(files)).build();
    }

    @Override
    public Response importPackage(String file) {
        PackageInfo packageInfo = this.importerService.preparePackage(file);
        return ResponseFactory.created(this.checkAndDoImport(packageInfo)).build();
    }

    @Override
    public Response importUploadedPackage(FileUpload form) {
        byte[] uploadedPackage = form.getFileData();
        PackageInfo packageInfo = this.importerService.preparePackage(uploadedPackage);
        return ResponseFactory.created(this.checkAndDoImport(packageInfo)).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RepositoryObject checkAndDoImport(PackageInfo packageInfo) {
        try {
            logger.debug("Going to import {} version {}", (Object)packageInfo.getApplicationId(), (Object)packageInfo.getApplicationVersion());
            if (this.repositoryService.checkNodeExists(packageInfo.getApplicationId())) {
                this.checkPermission(Permission.IMPORT_UPGRADE, Lists.newArrayList(packageInfo.getApplicationId()));
            } else {
                this.checkPermission(Permission.IMPORT_INITIAL);
            }
            String id = this.importerService.importPackage(packageInfo);
            Object objectEntity = this.repositoryService.read(id);
            RepositoryObject repositoryObject = this.dtoConverter.toDto((RepositoryObjectEntity)objectEntity);
            return repositoryObject;
        }
        finally {
            this.importerService.cleanUp(packageInfo);
        }
    }
}

