/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.core.api.SecurityProxy;
import com.xebialabs.deployit.core.api.dto.RepositoryObjectIds;
import com.xebialabs.deployit.core.api.resteasy.http.tunnel.ResponseFactory;
import com.xebialabs.deployit.exception.DeployitException;
import com.xebialabs.deployit.exception.HttpResponseCodeResult;
import com.xebialabs.deployit.security.permission.Permission;
import javax.ws.rs.core.Response;
import org.springframework.stereotype.Controller;

@Controller
public class SecurityResource
implements SecurityProxy {
    @Override
    public Response grant(String permission, String toUser, RepositoryObjectIds onConfigurationItems) {
        Permission perm = this.getPermission(permission);
        perm.getPermissionHandler().grant(toUser, onConfigurationItems.getRepositoryEntityIds());
        return ResponseFactory.noContent().build();
    }

    @Override
    public Response deny(String permission, String toUser, RepositoryObjectIds onConfigurationItems) {
        Permission perm = this.getPermission(permission);
        perm.getPermissionHandler().deny(toUser, onConfigurationItems.getRepositoryEntityIds());
        return ResponseFactory.noContent().build();
    }

    @Override
    public Response revoke(String permission, String fromUser, RepositoryObjectIds onConfigurationItems) {
        Permission perm = this.getPermission(permission);
        perm.getPermissionHandler().revoke(fromUser, onConfigurationItems.getRepositoryEntityIds());
        return ResponseFactory.noContent().build();
    }

    private Permission getPermission(String permissionName) {
        Permission permission = Permission.find(permissionName);
        if (permission == null) {
            throw new UnknownPermissionException(permissionName);
        }
        return permission;
    }

    @HttpResponseCodeResult(statusCode=400)
    public static class UnknownPermissionException
    extends DeployitException {
        public UnknownPermissionException(String permission) {
            super("Permission %s does not exist.", permission);
        }
    }
}

