/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.hostsession;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.ci.OperatingSystemFamily;
import com.xebialabs.deployit.ci.UnreachableHost;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.hostsession.CommandExecution;
import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.hostsession.HostSessionFactory;
import java.io.File;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TunnelledHostSession
implements HostSession {
    private static final int DEFAULT_LOCAL_PORT = 9000;
    private static Logger logger = Logger.getLogger(TunnelledHostSession.class);
    private final int tunnelPort;
    private Session tunnel;
    private final HostSession tunnelledHostSession;

    public TunnelledHostSession(UnreachableHost host) {
        this.tunnelPort = this.startTunnel(host);
        this.tunnelledHostSession = HostSessionFactory.getHostSession(host.getOperatingSystemFamily(), host.getAccessMethod(), Host.getLocalHost().getAddress(), this.tunnelPort, host.getUsername(), host.getPassword(), host.getSudoUsername(), host.getTemporaryDirectoryLocation());
    }

    private int startTunnel(UnreachableHost host) throws RuntimeIOException {
        int localPort = TunnelledHostSession.findAvailablePort(9000);
        final Host jumpingStation = host.getJumpingStation();
        JSch jsch = new JSch();
        try {
            this.tunnel = jsch.getSession(jumpingStation.getUsername(), jumpingStation.getAddress());
            this.tunnel.setPassword(jumpingStation.getPassword());
            this.tunnel.setUserInfo(new UserInfo(){

                public String getPassphrase() {
                    return null;
                }

                public String getPassword() {
                    return jumpingStation.getPassword();
                }

                public boolean promptPassword(String s) {
                    return true;
                }

                public boolean promptPassphrase(String s) {
                    return true;
                }

                public boolean promptYesNo(String s) {
                    return true;
                }

                public void showMessage(String s) {
                }
            });
            this.tunnel.connect();
            this.tunnel.setPortForwardingL(localPort, host.getAddress(), 22);
            logger.info(String.format("Started SSH tunnel on port %d via %s to %s", localPort, jumpingStation.getAddress(), host.getAddress()));
            return localPort;
        }
        catch (JSchException e) {
            try {
                this.close();
            }
            catch (Exception ex) {
                logger.error("Error closing SSH tunnel", ex);
            }
            throw new RuntimeIOException("Unable to start SSH tunneling", e);
        }
    }

    private static int findAvailablePort(int startingPort) {
        int port = startingPort;
        while (!TunnelledHostSession.available(port)) {
            ++port;
        }
        return port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean available(int port) {
        block14: {
            ServerSocket ss = null;
            DatagramSocket ds = null;
            try {
                ss = new ServerSocket(port);
                ss.setReuseAddress(true);
                ds = new DatagramSocket(port);
                ds.setReuseAddress(true);
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                if (ds != null) {
                    ds.close();
                }
                if (ss == null) break block14;
                try {
                    ss.close();
                }
                catch (IOException e2) {
                    throw new RuntimeIOException("Unable to find an available local port for a tunnel", e2);
                }
            }
            finally {
                if (ds != null) {
                    ds.close();
                }
                if (ss != null) {
                    try {
                        ss.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeIOException("Unable to find an available local port for a tunnel", e);
                    }
                }
            }
        }
        return false;
    }

    @Override
    public void close() {
        if (this.tunnelledHostSession != null) {
            this.tunnelledHostSession.close();
        }
        if (this.tunnel != null) {
            this.tunnel.disconnect();
            logger.info(String.format("Tunnel on port %d via %s closed", this.tunnelPort, this.tunnel.getHost()));
        }
    }

    @Override
    public OperatingSystemFamily getHostOperatingSystem() {
        return this.tunnelledHostSession.getHostOperatingSystem();
    }

    @Override
    public HostFile getFile(String hostPath) throws RuntimeIOException {
        return this.tunnelledHostSession.getFile(hostPath);
    }

    @Override
    public HostFile getFile(HostFile parent, String child) throws RuntimeIOException {
        return this.tunnelledHostSession.getFile(parent, child);
    }

    @Override
    public HostFile getTempFile(String nameTemplate) throws RuntimeIOException {
        return this.tunnelledHostSession.getTempFile(nameTemplate);
    }

    @Override
    public HostFile getTempFile(String prefix, String suffix) throws RuntimeIOException {
        return this.tunnelledHostSession.getTempFile(prefix, suffix);
    }

    @Override
    public int execute(CommandExecutionCallbackHandler handler, String ... commandLine) throws RuntimeIOException {
        return this.tunnelledHostSession.execute(handler, commandLine);
    }

    @Override
    public int execute(CommandExecutionCallbackHandler handler, Map<String, String> inputResponse, String ... commandLine) {
        return this.tunnelledHostSession.execute(handler, inputResponse, commandLine);
    }

    @Override
    public CommandExecution startExecute(String ... commandLine) {
        return this.tunnelledHostSession.startExecute(commandLine);
    }

    @Override
    public HostFile copyToTemporaryFile(File localFile) throws RuntimeIOException {
        return this.tunnelledHostSession.copyToTemporaryFile(localFile);
    }

    @Override
    public HostFile copyToTemporaryFile(Resource resource) throws RuntimeIOException {
        return this.tunnelledHostSession.copyToTemporaryFile(resource);
    }
}

