/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.hostsession.local;

import com.xebialabs.deployit.ci.OperatingSystemFamily;
import com.xebialabs.deployit.exception.AbortedException;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.hostsession.CommandExecution;
import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.hostsession.common.AbstractHostSession;
import com.xebialabs.deployit.hostsession.common.ErrorStreamToCallbackHandler;
import com.xebialabs.deployit.hostsession.common.InputResponseHandler;
import com.xebialabs.deployit.hostsession.common.OutputStreamToCallbackHandler;
import com.xebialabs.deployit.hostsession.local.LocalHostFile;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalHostSession
extends AbstractHostSession
implements HostSession {
    private static Logger logger = Logger.getLogger(LocalHostSession.class);

    public LocalHostSession(OperatingSystemFamily os, String temporaryDirectoryPath) {
        super(os, temporaryDirectoryPath);
    }

    @Override
    public HostFile getTempFile(String prefix, String suffix) throws RuntimeIOException {
        try {
            return new LocalHostFile(this, File.createTempFile(prefix, suffix, new File(this.getTemporaryDirectory().getPath())));
        }
        catch (IOException exc) {
            throw new RuntimeIOException(exc);
        }
    }

    @Override
    public HostFile getFile(String hostPath) throws RuntimeIOException {
        return new LocalHostFile(this, new File(hostPath));
    }

    @Override
    public HostFile getFile(HostFile parent, String child) throws RuntimeIOException {
        if (!(parent instanceof LocalHostFile)) {
            throw new IllegalStateException("parent is not a file on the local host");
        }
        File parentFile = ((LocalHostFile)parent).getFile();
        return new LocalHostFile(this, new File(parentFile, child));
    }

    @Override
    public int execute(CommandExecutionCallbackHandler handler, String ... cmdarray) throws RuntimeIOException {
        return this.execute(handler, Collections.EMPTY_MAP, cmdarray);
    }

    @Override
    public int execute(CommandExecutionCallbackHandler handler, Map<String, String> inputResponse, String ... cmdarray) {
        Process proc;
        String commandLineForLogging = this.encodeCommandLineForLogging(cmdarray);
        try {
            if (this.getHostOperatingSystem() == OperatingSystemFamily.WINDOWS) {
                logger.debug("Enabling Windows specific command line encoding");
                logger.info("Executing local command: " + commandLineForLogging);
                proc = Runtime.getRuntime().exec(this.encodeCommandLineForExecution(cmdarray));
            } else {
                logger.info("Executing local command: " + commandLineForLogging);
                proc = Runtime.getRuntime().exec(cmdarray);
            }
        }
        catch (IOException exc) {
            throw new RuntimeIOException("Could not start local command: " + commandLineForLogging, exc);
        }
        InputResponseHandler responseHandler = new InputResponseHandler(handler, proc.getOutputStream(), inputResponse);
        Thread outputGobblerThread = new Thread(new OutputStreamToCallbackHandler(proc.getInputStream(), responseHandler));
        outputGobblerThread.start();
        Thread errorGobblerThread = new Thread(new ErrorStreamToCallbackHandler(proc.getErrorStream(), responseHandler));
        errorGobblerThread.start();
        try {
            outputGobblerThread.join();
            errorGobblerThread.join();
            return proc.waitFor();
        }
        catch (InterruptedException exc) {
            Thread.currentThread().interrupt();
            throw new AbortedException("Local command was interrupted: " + commandLineForLogging, exc);
        }
    }

    @Override
    public CommandExecution startExecute(String ... commandLine) {
        return null;
    }

    public String toString() {
        return "localhost";
    }
}

