/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.hostsession.ssh;

import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.log4j.Logger;

public class SshInteractiveSudoPasswordPromptHandler
implements CommandExecutionCallbackHandler {
    private CommandExecutionCallbackHandler decoratedHandler;
    private OutputStream remoteStdin;
    private byte[] passwordBytes;
    private StringBuffer receivedOutputBuffer = new StringBuffer();
    private boolean onFirstLine = true;
    private boolean justSawPasswordPrompt = false;
    private static Logger logger = Logger.getLogger(SshInteractiveSudoPasswordPromptHandler.class);

    public SshInteractiveSudoPasswordPromptHandler(CommandExecutionCallbackHandler decoratedHandler, OutputStream remoteStdin, String password) {
        this.decoratedHandler = decoratedHandler;
        this.remoteStdin = remoteStdin;
        this.passwordBytes = (password + "\r\n").getBytes();
    }

    public void handleOutput(char c) {
        this.decoratedHandler.handleOutput(c);
        if (this.onFirstLine) {
            this.receivedOutputBuffer.append(c);
            String receivedOutput = this.receivedOutputBuffer.toString();
            if (c == ':' && receivedOutput.contains("assword")) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Found password prompt in first line of output: " + receivedOutput);
                }
                try {
                    this.remoteStdin.write(this.passwordBytes);
                    this.remoteStdin.flush();
                    if (logger.isDebugEnabled()) {
                        logger.debug("Sent password");
                    }
                }
                catch (IOException exc) {
                    logger.error("Cannot send password", exc);
                }
                this.justSawPasswordPrompt = true;
            }
        }
    }

    public void handleOutputLine(String line) {
        if (!this.justSawPasswordPrompt) {
            this.decoratedHandler.handleOutputLine(line);
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("Not sending line with password prompt to decorated handler: " + line);
            }
            this.justSawPasswordPrompt = false;
        }
        this.onFirstLine = false;
    }

    public void handleErrorLine(String line) {
        this.decoratedHandler.handleErrorLine(line);
        this.onFirstLine = false;
    }
}

