/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.hostsession.ssh;

import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.hostsession.CapturingCommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.ssh.SshScpHostFile;
import com.xebialabs.deployit.hostsession.ssh.SshSudoHostSession;
import com.xebialabs.deployit.hostsession.ssh.SshSudoOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

class SshSudoHostFile
extends SshScpHostFile
implements HostFile {
    private SshSudoHostSession sshSudoHostSession;
    private boolean isTempFile;
    private Logger logger = Logger.getLogger(SshSudoHostFile.class);

    public SshSudoHostFile(SshSudoHostSession session, String remotePath, boolean isTempFile) {
        super(session, remotePath);
        this.sshSudoHostSession = session;
        this.isTempFile = isTempFile;
    }

    protected int executeCommand(CommandExecutionCallbackHandler handler, String ... command) {
        if (this.isTempFile) {
            return this.sshSudoHostSession.noSudoExecute(handler, command);
        }
        return super.executeCommand(handler, command);
    }

    public HostFile getFile(String name) {
        SshSudoHostFile f = (SshSudoHostFile)super.getFile(name);
        f.isTempFile = this.isTempFile;
        return f;
    }

    public HostFile getParentFile() {
        SshSudoHostFile f = (SshSudoHostFile)super.getParentFile();
        f.isTempFile = this.isTempFile;
        return f;
    }

    public InputStream get() throws RuntimeIOException {
        if (this.isTempFile) {
            return super.get();
        }
        HostFile tempFile = this.getTempFile(true);
        this.copyHostFileToTempFile(tempFile);
        return tempFile.get();
    }

    private void copyHostFileToTempFile(HostFile tempFile) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Copying " + this + " to " + tempFile + " for reading");
        }
        CapturingCommandExecutionCallbackHandler capturedOutput = new CapturingCommandExecutionCallbackHandler();
        int result = this.session.execute((CommandExecutionCallbackHandler)capturedOutput, "cp", this.getPath(), tempFile.getPath());
        if (result != 0) {
            String errorMessage = capturedOutput.getAll();
            throw new RuntimeIOException("Cannot copy " + this + " to " + tempFile + " for reading: " + errorMessage);
        }
    }

    public OutputStream put(long length) throws RuntimeIOException {
        if (this.isTempFile) {
            return super.put(length);
        }
        SshSudoOutputStream out = new SshSudoOutputStream(this, length, this.getTempFile(false));
        out.open();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Opened SUDO output stream to remote file " + this);
        }
        return out;
    }

    protected HostFile getTempFile(boolean useSudoForDeletion) {
        String prefix = FilenameUtils.getBaseName(this.getPath());
        String suffix = FilenameUtils.getExtension(this.getPath());
        return this.sshSudoHostSession.getTempFile(prefix, suffix);
    }

    public void mkdir() throws RuntimeIOException {
        if (!this.isTempFile) {
            super.mkdir();
        } else {
            this.logger.debug("Making directory world-writable (with sticky bit)");
            this.mkdir(new String[]{"-m", "1777"});
        }
    }
}

