/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.hostsession.ssh;

import com.xebialabs.deployit.ci.OperatingSystemFamily;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.hostsession.CommandExecution;
import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.ssh.SshHostSession;
import com.xebialabs.deployit.hostsession.ssh.SshSudoHostFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SshSudoHostSession
extends SshHostSession {
    protected String sudoUsername;
    private Logger logger = Logger.getLogger(SshSudoHostSession.class);

    public SshSudoHostSession(OperatingSystemFamily os, String temporaryDirectoryPath, String host, int port, String username, String password, String sudoUsername) {
        super(os, temporaryDirectoryPath, host, port, username, password);
        this.sudoUsername = sudoUsername;
        this.open();
    }

    @Override
    public int execute(CommandExecutionCallbackHandler handler, Map<String, String> inputResponse, String ... commandLine) throws RuntimeIOException {
        String[] commandLineWithSudo = this.prependSudoCommand(commandLine);
        return super.execute(handler, inputResponse, commandLineWithSudo);
    }

    @Override
    public CommandExecution startExecute(String ... commandLine) {
        String[] commandLineWithSudo = this.prependSudoCommand(commandLine);
        return super.startExecute(commandLineWithSudo);
    }

    protected String[] prependSudoCommand(String ... commandLine) {
        ArrayList<String> sudoCommandLine = new ArrayList<String>();
        for (int i = 0; i < commandLine.length; ++i) {
            if (i == 0) {
                this.addSudoStatement(sudoCommandLine);
            }
            sudoCommandLine.add(commandLine[i]);
            if (!commandLine[i].equals("|") && !commandLine[i].equals(";")) continue;
            this.addSudoStatement(sudoCommandLine);
        }
        String[] commandLineWithSudo = sudoCommandLine.toArray(new String[sudoCommandLine.size()]);
        return commandLineWithSudo;
    }

    protected void addSudoStatement(List<String> sudoCommandLineCollector) {
        sudoCommandLineCollector.add("sudo");
        sudoCommandLineCollector.add("-u");
        sudoCommandLineCollector.add(this.sudoUsername);
    }

    protected int noSudoExecute(CommandExecutionCallbackHandler handler, String ... commandLine) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("NOT adding sudo statement");
        }
        return super.execute(handler, Collections.EMPTY_MAP, commandLine);
    }

    @Override
    protected HostFile getFile(String hostPath, boolean isTempFile) throws RuntimeIOException {
        return new SshSudoHostFile(this, hostPath, isTempFile);
    }

    @Override
    protected HostFile createSessionTempDirectory(HostFile systemTempDirectory, String name) {
        HostFile f = this.getFile(systemTempDirectory, name, true);
        if (!f.exists()) {
            f.mkdir();
            return f;
        }
        return null;
    }

    @Override
    public String toString() {
        return this.username + "@" + this.host + ":" + this.port + " (sudo to " + this.sudoUsername + ")";
    }
}

