/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.hostsession.ssh;

import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.hostsession.CapturingCommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.ssh.SshSudoHostFile;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.log4j.Logger;

class SshSudoOutputStream
extends OutputStream {
    private HostFile tempFile;
    private SshSudoHostFile hostFile;
    private long length;
    private OutputStream tempFileOutputStream;
    private Logger logger = Logger.getLogger(SshSudoOutputStream.class);

    public SshSudoOutputStream(SshSudoHostFile hostFile, long length, HostFile tempFile) {
        this.hostFile = hostFile;
        this.length = length;
        this.tempFile = tempFile;
    }

    void open() {
        this.tempFileOutputStream = this.tempFile.put(this.length);
    }

    public void write(int b) throws IOException {
        this.tempFileOutputStream.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.tempFileOutputStream.write(b, off, len);
    }

    public void write(byte[] b) throws IOException {
        this.tempFileOutputStream.write(b);
    }

    public void close() throws IOException {
        this.tempFileOutputStream.close();
        this.copyTempFileToHostFile();
    }

    private void copyTempFileToHostFile() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Copying " + this.tempFile + " to " + this.hostFile + " after writing");
        }
        CapturingCommandExecutionCallbackHandler capturedOutput = new CapturingCommandExecutionCallbackHandler();
        int result = this.hostFile.getSession().execute((CommandExecutionCallbackHandler)capturedOutput, "cp", this.tempFile.getPath(), this.hostFile.getPath());
        if (result != 0) {
            String errorMessage = capturedOutput.getAll();
            throw new RuntimeIOException("Cannot copy " + this.tempFile + " to " + this.hostFile + " after writing: " + errorMessage);
        }
    }
}

