/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.jetty;

import com.xebialabs.deployit.jetty.HttpMethodOverrideServletRequest;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodOverrideFilter
implements Filter {
    public static final String HEADER_PARAM = "methodOverrideHeader";
    private String header;
    private static Logger logger = LoggerFactory.getLogger(MethodOverrideFilter.class);

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        this.header = filterConfig.getInitParameter(HEADER_PARAM);
        if (this.header == null || this.header.length() == 0) {
            this.header = "X-HTTP-Method-Override";
        }
        logger.info("Initialized to check for header {}", (Object)this.header);
    }

    @Override
    public void destroy() {
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        ServletRequest filteredRequest = request;
        if (request instanceof HttpServletRequest) {
            filteredRequest = this.processRequest(request);
        }
        chain.doFilter(filteredRequest, response);
    }

    protected ServletRequest processRequest(ServletRequest request) {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        return new HttpMethodOverrideServletRequest(httpRequest, this.header);
    }
}

