/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.jetty;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseCodeManglingFilter
implements Filter {
    protected static final String X_ORIGINAL_STATUS = "X-Original-Status";
    protected static final String X_WANT_OK_STATUS = "X-Want-Ok-Status";
    private static final Logger logger = LoggerFactory.getLogger(ResponseCodeManglingFilter.class);

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        logger.debug("Added Hide responsecode Filter");
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        ServletResponse httpResponse;
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            String s = ((HttpServletRequest)request).getHeader(X_WANT_OK_STATUS);
            if (s != null && !"".equals(s.trim())) {
                logger.debug("Hiding Response Code if necessary");
                httpResponse = new HttpReponseOkWrapper((HttpServletResponse)response);
            } else {
                httpResponse = response;
            }
        } else {
            httpResponse = response;
        }
        chain.doFilter(request, httpResponse);
    }

    @Override
    public void destroy() {
    }

    private class HttpReponseOkWrapper
    extends HttpServletResponseWrapper {
        private HttpReponseOkWrapper(HttpServletResponse response) {
            super(response);
        }

        @Override
        public void setStatus(int sc) {
            int code = this._determineCorrectStatusCode(sc);
            super.setStatus(code);
        }

        private int _determineCorrectStatusCode(int sc) {
            this.addHeader(ResponseCodeManglingFilter.X_ORIGINAL_STATUS, Integer.toString(sc));
            if (sc >= 400) {
                logger.info("Hiding status code {} with {}", sc, (Object)207);
                return 207;
            }
            return sc;
        }

        @Override
        public void setStatus(int sc, String sm) {
            int code = this._determineCorrectStatusCode(sc);
            super.setStatus(code, sm);
        }

        @Override
        public void sendError(int sc) throws IOException {
            int code = this._determineCorrectStatusCode(sc);
            super.sendError(code);
        }

        @Override
        public void sendError(int sc, String msg) throws IOException {
            int code = this._determineCorrectStatusCode(sc);
            super.sendError(code, msg);
        }
    }
}

