/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository;

import com.xebialabs.deployit.repository.ArchetypeEntity;
import com.xebialabs.deployit.repository.FlattenedEntity;
import com.xebialabs.deployit.repository.RepositoryObjectEntity;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class Flattener {
    public FlattenedEntity flatten(RepositoryObjectEntity entity) {
        FlattenedEntity flattened = new FlattenedEntity(entity);
        this.flattenArchetypes(entity.getConfigurationItemArchetype(), flattened);
        this.storeValues(entity.getValues(), flattened);
        return flattened;
    }

    private void flattenArchetypes(ArchetypeEntity archetype, RepositoryObjectEntity flattened) {
        if (archetype != null) {
            this.flattenArchetypes(archetype.getConfigurationItemArchetype(), flattened);
            this.storeValues(archetype.getValues(), flattened);
        }
    }

    private void storeValues(Map<String, Object> values, RepositoryObjectEntity flattened) {
        for (String key : values.keySet()) {
            flattened.addValue(key, values.get(key));
        }
    }
}

