/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository;

import com.xebialabs.deployit.ConfigurationItemRoot;
import org.apache.commons.lang.StringUtils;

public class JcrPathHelper {
    public static String getAbsolutePathFromId(String id) {
        return "/" + id;
    }

    public static String getIdFromAbsolutePath(String absPath) {
        return StringUtils.stripStart(absPath, "/");
    }

    public static String toValidNodeName(String str) {
        return str.replace('/', '_');
    }

    public static String buildId(ConfigurationItemRoot root, String ... pathComponents) {
        return JcrPathHelper.buildId(root.getRootNodeName(), pathComponents);
    }

    public static String buildId(String parentId, String ... pathComponents) {
        StringBuilder b = new StringBuilder();
        b.append(parentId);
        for (String each : pathComponents) {
            b.append('/').append(each);
        }
        return b.toString();
    }

    public static String getParentId(String id) {
        int lastSlashPos = StringUtils.lastIndexOf(id, '/');
        if (lastSlashPos > 0) {
            return id.substring(0, lastSlashPos);
        }
        return "";
    }
}

