/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.reflect.ConfigurationItemDescriptor;
import com.xebialabs.deployit.reflect.ConfigurationItemPropertyDescriptor;
import com.xebialabs.deployit.reflect.ConfigurationItemPropertyType;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.typedescriptor.ConfigurationItemTypeDescriptorRepository;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchQueryBuilder {
    public static final String CI_SELECTOR_NAME = "ci";
    private static final String EQUALITY_OPERATOR = "=";
    private static final String LIKE_OPERATOR = "LIKE";
    private static final String ISCHILDNODE_OPERATOR = "ISCHILDNODE";
    private final ConfigurationItemTypeDescriptorRepository descriptorRepository;
    private final SearchParameters parameters;
    private final StringBuilder joins;
    private final List<Condition> conditions;
    private int nextSelectorId = 1;
    private static final Logger logger = LoggerFactory.getLogger(SearchQueryBuilder.class);

    public SearchQueryBuilder(ConfigurationItemTypeDescriptorRepository descriptorRepository, SearchParameters parameters) {
        this.descriptorRepository = descriptorRepository;
        this.parameters = parameters;
        this.joins = new StringBuilder();
        this.conditions = Lists.newArrayList();
    }

    public Query build(Session session) throws RepositoryException {
        this.createJoinsAndConditions();
        QueryManager qm = session.getWorkspace().getQueryManager();
        ValueFactory valueFactory = session.getValueFactory();
        String q = this.constructQueryString();
        Query query = qm.createQuery(q, "JCR-SQL2");
        this.addBinds(valueFactory, query);
        this.addPagingInfo(query);
        logger.debug("Query built: {}", (Object)query.getStatement());
        return query;
    }

    String constructQueryString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ci.* FROM ");
        builder.append("[");
        if (this.parameters.at == null) {
            builder.append(this.parameters.archetypes ? "deployit:archetype" : "deployit:configurationItem");
        } else {
            builder.append("{http://www.jcp.org/jcr/nt/1.0}base");
        }
        builder.append("]  AS ci");
        builder.append(this.joins.toString());
        if (!this.conditions.isEmpty()) {
            builder.append(" WHERE ");
            builder.append(StringUtils.join(CollectionUtils.collect(this.conditions, new Transformer(){

                @Override
                public Object transform(Object input) {
                    return ((Condition)input).build();
                }
            }), " AND "));
        }
        builder.append(" ORDER BY ci.[$id]");
        logger.debug("Built query: {}", (Object)builder.toString());
        return builder.toString();
    }

    private void addBinds(ValueFactory valueFactory, Query query) throws RepositoryException {
        for (Condition eachCondition : this.conditions) {
            if (eachCondition.parameter == null) continue;
            for (int i = 0; i < eachCondition.values.length; ++i) {
                Value v;
                Object eachValue = eachCondition.values[i];
                if (eachValue instanceof String) {
                    v = valueFactory.createValue((String)eachValue);
                } else if (eachValue instanceof Calendar) {
                    v = valueFactory.createValue((Calendar)eachValue);
                } else {
                    throw new IllegalArgumentException("Value of Condition is not a String or a Calendar but a " + eachValue.getClass().getName());
                }
                query.bindValue(eachCondition.parameter + i, v);
                logger.debug("Bound {} to {}", (Object)(eachCondition.parameter + i), (Object)v);
            }
        }
    }

    void addPagingInfo(Query query) {
        if (this.parameters.resultsPerPage > 0L) {
            query.setLimit(this.parameters.resultsPerPage);
            query.setOffset(this.parameters.page * this.parameters.resultsPerPage);
        }
    }

    private void createJoinsAndConditions() {
        this.createConditionForParent();
        this.createConditionForId();
        this.createConditionForConfigurationItemTypeName();
        this.createConditionForAt();
        this.createConditionForCreatingTaskId();
        this.createConditionsForProperties();
    }

    private void createConditionForConfigurationItemTypeName() {
        if (StringUtils.isNotBlank(this.parameters.configurationItemTypeName)) {
            List<ConfigurationItemDescriptor> descriptor = this.descriptorRepository.getDescriptorsBySuperType(this.parameters.configurationItemTypeName);
            if (descriptor.isEmpty()) {
                logger.warn("Cannot search for configuration item type " + this.parameters.configurationItemTypeName + " because it is not a known type");
                this.conditions.add(Condition.from(CI_SELECTOR_NAME, "$configuration.item.type", "_configurationItemTypeName", EQUALITY_OPERATOR, false, this.parameters.configurationItemTypeName));
                return;
            }
            ArrayList<String> typenames = Lists.newArrayList();
            for (ConfigurationItemDescriptor each : descriptor) {
                typenames.add(each.getType());
            }
            this.conditions.add(Condition.from(CI_SELECTOR_NAME, "$configuration.item.type", "_configurationItemTypeName", EQUALITY_OPERATOR, false, typenames.toArray(new String[typenames.size()])));
        }
    }

    private void createConditionForParent() {
        if (StringUtils.isNotBlank(this.parameters.parent)) {
            if (this.parameters.at != null) {
                throw new IllegalArgumentException("Cannot combine fromPath and at search parameters");
            }
            String parent = this.parameters.parent;
            if (!StringUtils.startsWith(parent, "/")) {
                parent = "/" + parent;
            }
            this.conditions.add(Condition.from(CI_SELECTOR_NAME, "$id", null, ISCHILDNODE_OPERATOR, parent));
        }
    }

    private void createConditionForId() {
        if (StringUtils.isNotBlank(this.parameters.id)) {
            if (this.parameters.id.contains("%")) {
                this.conditions.add(Condition.imatch(CI_SELECTOR_NAME, "$id", "_id", this.parameters.id));
            } else {
                this.conditions.add(Condition.match(CI_SELECTOR_NAME, "$id", "_id", this.parameters.id));
            }
        }
    }

    private void createConditionForAt() {
        if (this.parameters.at != null) {
            this.conditions.add(Condition.from(CI_SELECTOR_NAME, "$lastModified", "_at", "<=", this.parameters.at));
        }
    }

    private void createConditionForCreatingTaskId() {
        if (this.parameters.creatingTaskId != null) {
            this.conditions.add(Condition.from(CI_SELECTOR_NAME, "$creatingTaskId", "_creatingTaskId", EQUALITY_OPERATOR, this.parameters.creatingTaskId));
        }
    }

    private void createConditionsForProperties() {
        for (Map.Entry<String, String> entry : this.parameters.properties.entrySet()) {
            this.createConditionForProperty(entry);
        }
    }

    protected void createConditionForProperty(Map.Entry<String, String> entry) {
        ConfigurationItemPropertyDescriptor propertyDescriptor;
        ConfigurationItemDescriptor descriptor;
        if (this.descriptorRepository != null && StringUtils.isNotBlank(this.parameters.configurationItemTypeName) && (descriptor = this.descriptorRepository.getDescriptorByType(this.parameters.configurationItemTypeName)) != null && (propertyDescriptor = descriptor.getPropertyDescriptor(entry.getKey())) != null) {
            if (propertyDescriptor.getType() == ConfigurationItemPropertyType.CI) {
                String selectorName = "referenced" + this.nextSelectorId;
                this.joins.append(" INNER JOIN [deployit:configurationItem] AS " + selectorName + " ON " + CI_SELECTOR_NAME + ".[" + entry.getKey() + "] = " + selectorName + ".[jcr:uuid]");
                this.conditions.add(Condition.match(selectorName, "$id", entry.getKey(), entry.getValue()));
                ++this.nextSelectorId;
                return;
            }
            if (propertyDescriptor.getType() == ConfigurationItemPropertyType.SET_OF_CIS) {
                throw new IllegalArgumentException("Cannot query property " + propertyDescriptor + " because it is of type SET_OF_CIS");
            }
        }
        this.conditions.add(Condition.match(CI_SELECTOR_NAME, entry.getKey(), entry.getKey(), entry.getValue()));
    }

    private static class Condition {
        String selector;
        String field;
        String operator;
        String parameter;
        Object[] values;
        boolean caseInsensitive;
        private static final String CASE_SENSITIVE = "%s.[%s] %s $%s";
        private static final String CASE_INSENSITIVE = "LOWER(%s.[%s]) %s $%s";
        private static final String ISCHILDNODE_FORMAT = "ISCHILDNODE(%s, ['%s'])";

        private Condition() {
        }

        String build() {
            StringBuilder conditionString = new StringBuilder();
            conditionString.append("(");
            for (int i = 0; i < this.values.length; ++i) {
                if (i > 0) {
                    conditionString.append(" OR ");
                }
                if (this.operator.equals(SearchQueryBuilder.ISCHILDNODE_OPERATOR)) {
                    conditionString.append(String.format(ISCHILDNODE_FORMAT, this.selector, this.values[i]));
                    continue;
                }
                conditionString.append(String.format(this.caseInsensitive ? CASE_INSENSITIVE : CASE_SENSITIVE, this.selector, this.field, this.operator, this.parameter + i));
            }
            conditionString.append(")");
            return conditionString.toString();
        }

        static Condition match(String selector, String field, String parameter, String value) {
            return Condition.match(selector, field, parameter, value, false);
        }

        static Condition imatch(String selector, String field, String parameter, String value) {
            return Condition.match(selector, field, parameter, value.toLowerCase(), true);
        }

        private static Condition match(String selector, String field, String parameter, String value, boolean caseInsensitive) {
            String operator = value.contains("%") ? SearchQueryBuilder.LIKE_OPERATOR : SearchQueryBuilder.EQUALITY_OPERATOR;
            return Condition.from(selector, field, parameter, operator, caseInsensitive, value);
        }

        static Condition from(String selector, String field, String parameter, String operator, Object value) {
            return Condition.from(selector, field, parameter, operator, false, value);
        }

        static Condition from(String selector, String field, String parameter, String operator, boolean caseInsensitive, Object ... values) {
            Condition t = new Condition();
            t.selector = selector;
            t.field = field;
            t.parameter = parameter;
            t.operator = operator;
            t.caseInsensitive = caseInsensitive;
            t.values = values;
            return t;
        }
    }
}

