/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security;

import com.google.common.collect.Lists;
import java.util.List;

public class JcrAccessControlEntry {
    private String principalName;
    private boolean allow;
    private List<String> privileges;
    private boolean transitive = true;

    public JcrAccessControlEntry(String principalName, boolean allow, String ... privileges) {
        this(principalName, allow, Lists.newArrayList(privileges));
    }

    public JcrAccessControlEntry(String principalName, boolean allow, List<String> privileges) {
        this.principalName = principalName;
        this.allow = allow;
        this.privileges = privileges;
    }

    public JcrAccessControlEntry(String principalName, boolean allow, List<String> privileges, boolean transitive) {
        this.allow = allow;
        this.principalName = principalName;
        this.privileges = privileges;
        this.transitive = transitive;
    }

    public String getPrincipalName() {
        return this.principalName;
    }

    public boolean isAllow() {
        return this.allow;
    }

    public List<String> getPrivileges() {
        return this.privileges;
    }

    public String toString() {
        return (this.allow ? "" : "Not ") + this.privileges + " for " + this.principalName;
    }

    public boolean isTransitive() {
        return this.transitive;
    }
}

