/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.jcr.JcrCallback;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.security.PermissionService;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.security.auth.Subject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.principal.PrincipalIterator;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.security.principal.AdminPrincipal;
import org.apache.jackrabbit.value.StringValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component(value="permissionService")
public class JcrPermissionService
implements PermissionService {
    @Autowired
    protected JcrTemplate jcrTemplate;
    private static final Logger logger = LoggerFactory.getLogger(JcrPermissionService.class);

    @Override
    public boolean hasPermission(final String permissionName, final String principalName) {
        return this.jcrTemplate.execute(new JcrCallback<Boolean>(){

            @Override
            public Boolean doInJcr(Session session) throws IOException, RepositoryException {
                PrincipalManager principalManager = ((JackrabbitSession)session).getPrincipalManager();
                Principal principal = principalManager.getPrincipal(principalName);
                if (JcrPermissionService.this.isAdmin(principal, permissionName)) {
                    return true;
                }
                List groups = JcrPermissionService.this.getGroupMemberships(principalManager, principal);
                return JcrPermissionService.this.checkHasPermission(session, groups, principalName, permissionName);
            }
        });
    }

    @Override
    public boolean hasPermission(final String permissionName) {
        final Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        return this.jcrTemplate.execute(new JcrCallback<Boolean>(){

            @Override
            public Boolean doInJcr(Session session) throws IOException, RepositoryException {
                Subject subject = ((SessionImpl)session).getSubject();
                PrincipalManager principalManager = ((JackrabbitSession)session).getPrincipalManager();
                ArrayList groups = Lists.newArrayList();
                for (Principal eachPrincipal : subject.getPrincipals()) {
                    if (JcrPermissionService.this.isAdmin(eachPrincipal, permissionName)) {
                        return true;
                    }
                    groups.addAll(JcrPermissionService.this.getGroupMemberships(principalManager, eachPrincipal));
                }
                String principalName = auth.getName();
                return JcrPermissionService.this.checkHasPermission(session, groups, principalName, permissionName);
            }
        });
    }

    private boolean isAdmin(Principal eachPrincipal, String permissionName) {
        if (eachPrincipal instanceof AdminPrincipal) {
            logger.debug("Granted {} because user is admin.", (Object)permissionName);
            return true;
        }
        return false;
    }

    private Boolean checkHasPermission(Session session, List<String> groups, String principalName, String permissionName) throws RepositoryException {
        Value[] allowedPrincipals;
        Node configNode = Preconditions.checkNotNull(session.getNode("/$configuration"));
        for (Value each : allowedPrincipals = this.getAllowedPrincipals(configNode, permissionName)) {
            String stringValue = each.getString();
            if (stringValue.equals(principalName)) {
                logger.debug("Granted {} because user {} has the permission.", (Object)permissionName, (Object)principalName);
                return true;
            }
            if (!groups.contains(stringValue)) continue;
            logger.debug("Granted {} because group {} has the permission.", (Object)permissionName, (Object)stringValue);
            return true;
        }
        return false;
    }

    @Override
    public void grantPermission(final String permissionName, final String ... principals) {
        logger.debug("Granting {} to {}", (Object)permissionName, (Object)Arrays.toString(principals));
        this.jcrTemplate.execute(new JcrCallback<Object>(){

            @Override
            public Object doInJcr(Session session) throws IOException, RepositoryException {
                Node configNode = Preconditions.checkNotNull(session.getNode("/$configuration"));
                HashSet<String> newPrincipalsList = Sets.newHashSet();
                for (Value each : JcrPermissionService.this.getAllowedPrincipals(configNode, permissionName)) {
                    newPrincipalsList.add(each.getString());
                }
                CollectionUtils.addAll(newPrincipalsList, principals);
                Collection<Value> newValueCollection = Collections2.transform(newPrincipalsList, new Function<String, Value>(){

                    @Override
                    public Value apply(String from) {
                        return new StringValue(from);
                    }
                });
                Value[] newValues = newValueCollection.toArray(new Value[newValueCollection.size()]);
                configNode.setProperty("permission-to-" + permissionName, newValues);
                session.save();
                return null;
            }
        });
    }

    @Override
    public void denyPermission(final String permissionName, final String ... principals) {
        this.jcrTemplate.execute(new JcrCallback<Object>(){

            @Override
            public Object doInJcr(Session session) throws IOException, RepositoryException {
                Node configNode = Preconditions.checkNotNull(session.getNode("/$configuration"));
                Value[] oldValues = JcrPermissionService.this.getAllowedPrincipals(configNode, permissionName);
                ArrayList<Value> newValueList = Lists.newArrayList();
                for (Value oldValue : oldValues) {
                    if (ArrayUtils.contains(principals, oldValue.getString())) continue;
                    newValueList.add(oldValue);
                }
                Value[] newValues = newValueList.toArray(new Value[newValueList.size()]);
                configNode.setProperty("permission-to-" + permissionName, newValues);
                session.save();
                return null;
            }
        });
    }

    protected Value[] getAllowedPrincipals(Node configNode, String permissionName) throws RepositoryException, ValueFormatException {
        Value[] oldValues;
        try {
            Property permissionProperty = configNode.getProperty("permission-to-" + permissionName);
            oldValues = permissionProperty.getValues();
        }
        catch (PathNotFoundException exc) {
            oldValues = new Value[]{};
        }
        return oldValues;
    }

    private List<String> getGroupMemberships(PrincipalManager principalManager, Principal principal) {
        PrincipalIterator groupPrincipals = principalManager.getGroupMembership(principal);
        ArrayList<String> groups = Lists.newArrayList();
        while (groupPrincipals.hasNext()) {
            Principal group = groupPrincipals.nextPrincipal();
            groups.add(group.getName());
        }
        return groups;
    }
}

