/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security.permission;

import com.xebialabs.deployit.security.SecurityServiceLocator;
import com.xebialabs.deployit.security.permission.Permission;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PermissionHelper {
    private static final Logger logger = LoggerFactory.getLogger(PermissionHelper.class);

    static void grantPermission(Permission permission, String user, String onConfigurationItem) {
        PermissionHelper.grantPermission(PermissionHelper.constructPermissionName(permission, onConfigurationItem), user);
    }

    static void grantPermission(Permission permission, String user) {
        PermissionHelper.grantPermission(permission.getPermissionName(), user);
    }

    private static void grantPermission(String permission, String user) {
        SecurityServiceLocator.getPermissionService().grantPermission(permission, user);
    }

    static void revokePermission(Permission permission, String user, String onConfigurationItem) {
        PermissionHelper.revokePermission(PermissionHelper.constructPermissionName(permission, onConfigurationItem), user);
    }

    static void revokePermission(Permission permission, String user) {
        PermissionHelper.revokePermission(permission.getPermissionName(), user);
    }

    private static void revokePermission(String permission, String user) {
        SecurityServiceLocator.getPermissionService().denyPermission(permission, user);
    }

    static boolean hasPermission(Permission permission) {
        return PermissionHelper.hasPermission(permission.getPermissionName());
    }

    private static boolean hasPermission(String permission) {
        return SecurityServiceLocator.getPermissionService().hasPermission(permission);
    }

    static boolean hasPermission(Permission permission, List<String> onConfigurationItems) {
        boolean allowed = !onConfigurationItems.isEmpty();
        for (String onConfigurationItem : onConfigurationItems) {
            allowed = allowed && PermissionHelper.hasPermission(permission, onConfigurationItem);
        }
        return allowed || PermissionHelper.hasPermission(permission);
    }

    private static boolean hasPermission(Permission permission, String onConfigurationItem) {
        return PermissionHelper.hasPermission(PermissionHelper.constructPermissionName(permission, onConfigurationItem));
    }

    static boolean hasPermission(Permission permission, String principal, String onConfigurationItem) {
        return SecurityServiceLocator.getPermissionService().hasPermission(PermissionHelper.constructPermissionName(permission, onConfigurationItem), principal);
    }

    private static String constructPermissionName(Permission permission, String onConfigurationItem) {
        StringBuilder builder = new StringBuilder(permission.getPermissionName());
        if (onConfigurationItem != null) {
            logger.info("constructing permission: {} with {} ", (Object)builder.toString(), (Object)onConfigurationItem);
            builder.append("_").append(onConfigurationItem.replaceAll("/", "\\$"));
        }
        return builder.toString();
    }
}

