/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.comparison;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.reflect.ConfigurationItemDescriptor;
import com.xebialabs.deployit.reflect.ConfigurationItemPropertyDescriptor;
import com.xebialabs.deployit.repository.FlattenedEntity;
import com.xebialabs.deployit.repository.Flattener;
import com.xebialabs.deployit.repository.RepositoryObjectEntity;
import com.xebialabs.deployit.typedescriptor.ConfigurationItemDescriptorRepositoryHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class Comparator {
    private static final String PASSWORD_OBFUSCATION = "********";
    @Autowired
    private Flattener flattener;

    public ListMultimap<String, String> compare(RepositoryObjectEntity reference, RepositoryObjectEntity ... entities) {
        ArrayListMultimap<String, String> comparison = ArrayListMultimap.create();
        this.checkCiTypes(reference.getConfigurationItemTypeName(), entities);
        ConfigurationItemDescriptor descriptor = ConfigurationItemDescriptorRepositoryHolder.getDescriptor(reference);
        int nrCi = 0;
        ArrayList<RepositoryObjectEntity> entitiesToCompare = Lists.newArrayList();
        entitiesToCompare.add(reference);
        entitiesToCompare.addAll(Arrays.asList(entities));
        for (RepositoryObjectEntity compareEntity : entitiesToCompare) {
            FlattenedEntity flattened = this.flattener.flatten(compareEntity);
            this.writeFields(comparison, flattened);
            this.writeProperties(comparison, flattened, descriptor, nrCi);
            ++nrCi;
        }
        return comparison;
    }

    private void writeProperties(ListMultimap<String, String> comparison, RepositoryObjectEntity entity, ConfigurationItemDescriptor descriptor, int nrCi) {
        ConfigurationItemPropertyDescriptor[] descriptors;
        block5: for (ConfigurationItemPropertyDescriptor propertyDescriptor : descriptors = descriptor.getPropertyDescriptors()) {
            String key = propertyDescriptor.getName();
            Object value = entity.getValue(key);
            if (propertyDescriptor.isPassword()) {
                value = PASSWORD_OBFUSCATION;
            }
            switch (propertyDescriptor.getType()) {
                case BOOLEAN: 
                case INTEGER: 
                case STRING: 
                case ENUM: 
                case CI: {
                    comparison.put(key, (String)value);
                    continue block5;
                }
                case SET_OF_STRINGS: 
                case SET_OF_CIS: {
                    this.handleSetOfString(comparison, key, (Collection)value, nrCi);
                    continue block5;
                }
                case LIST_OF_OBJECTS: {
                    if (value == null) continue block5;
                    this.handleListOfObjects(comparison, key, (List)value, propertyDescriptor, nrCi);
                    continue block5;
                }
            }
        }
    }

    private void handleSetOfString(ListMultimap<String, String> comparison, String key, Collection<String> value, int nrCi) {
        if (value != null) {
            ArrayList<String> list = new ArrayList<String>(value);
            Collections.sort(list);
            this.setOrAdd(comparison, key, StringUtils.join(list, ","), nrCi);
        } else {
            this.setOrAdd(comparison, key, null, nrCi);
        }
    }

    private void setOrAdd(ListMultimap<String, String> comparison, String key, String value, int index) {
        List<String> stringList = comparison.get(key);
        if (stringList.size() > index) {
            stringList.set(index, value);
        } else if (stringList.size() == index) {
            stringList.add(value);
        } else {
            for (int i = stringList.size(); i < index; ++i) {
                stringList.add(null);
            }
            stringList.add(value);
        }
    }

    private void handleListOfObjects(ListMultimap<String, String> comparison, String key, List<Map<String, Object>> objectList, ConfigurationItemPropertyDescriptor propertyDescriptor, int nrCi) {
        int index = 0;
        ConfigurationItemPropertyDescriptor[] descriptors = propertyDescriptor.getListObjectPropertyDescriptors();
        for (Map<String, Object> map : objectList) {
            String keyPrefix = key + index + ".";
            block6: for (ConfigurationItemPropertyDescriptor descriptor : descriptors) {
                switch (descriptor.getType()) {
                    case BOOLEAN: 
                    case INTEGER: 
                    case STRING: 
                    case ENUM: 
                    case CI: {
                        this.setOrAdd(comparison, keyPrefix + descriptor.getName(), (String)map.get(descriptor.getName()), nrCi);
                        continue block6;
                    }
                    case SET_OF_STRINGS: 
                    case SET_OF_CIS: {
                        this.handleSetOfString(comparison, keyPrefix + descriptor.getName(), (Collection)map.get(descriptor.getName()), nrCi);
                        continue block6;
                    }
                    case LIST_OF_OBJECTS: {
                        continue block6;
                    }
                }
            }
            ++index;
        }
    }

    private void writeFields(ListMultimap<String, String> comparison, FlattenedEntity entity) {
        comparison.put("id", entity.getId());
        comparison.put("type", entity.getConfigurationItemTypeName());
        comparison.put("archetypeId", entity.getArchetypeId());
    }

    private void checkCiTypes(String referenceType, RepositoryObjectEntity ... entities) {
        for (RepositoryObjectEntity entity : entities) {
            Checks.checkArgument(entity.getConfigurationItemTypeName().equals(referenceType), "Not all configuration items are of type %s", referenceType);
        }
    }
}

