/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.translation;

import com.xebialabs.deployit.ConfigurationItemRoot;
import com.xebialabs.deployit.reflect.ConfigurationItemDescriptor;
import com.xebialabs.deployit.reflect.ConfigurationItemPropertyDescriptor;
import com.xebialabs.deployit.repository.JcrPathHelper;
import com.xebialabs.deployit.typedescriptor.ConfigurationItemTypeDescriptorRepository;
import java.io.Serializable;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DiscoveryIdGenerator {
    @Autowired
    private ConfigurationItemTypeDescriptorRepository repository;

    public void generateCorrectIds(Collection<Serializable> discoveredItems) {
        for (Serializable each : discoveredItems) {
            this.generateCorrectId(each);
        }
    }

    private void generateCorrectId(Serializable discoveredItem) {
        ConfigurationItemDescriptor descriptor = this.repository.getDescriptorForObject(discoveredItem);
        if (descriptor == null) {
            throw new IllegalStateException("Cannot find descriptor for object of class " + discoveredItem.getClass().getName());
        }
        String discoveredItemId = descriptor.getLabelValueFromConfigurationItem(discoveredItem);
        if (discoveredItemId.contains("/")) {
            return;
        }
        ConfigurationItemRoot root = descriptor.getRoot();
        if (root != ConfigurationItemRoot.NESTED) {
            this.generateIdBasedOnRoot(discoveredItem, descriptor, discoveredItemId, root);
            return;
        }
        for (ConfigurationItemPropertyDescriptor eachPropertyDescriptor : descriptor.getPropertyDescriptors()) {
            if (!eachPropertyDescriptor.asContainment()) continue;
            this.generateIdBasedOnParentId(discoveredItem, descriptor, discoveredItemId, eachPropertyDescriptor);
            return;
        }
        throw new IllegalArgumentException("The discovered item " + discoveredItemId + " is not rooted and does not have a parent");
    }

    private void generateIdBasedOnRoot(Serializable discoveredItem, ConfigurationItemDescriptor descriptor, String discoveredItemId, ConfigurationItemRoot root) {
        String generatedId = JcrPathHelper.buildId(root, discoveredItemId);
        descriptor.setLabelValueInConfigurationItem(discoveredItem, generatedId);
    }

    private void generateIdBasedOnParentId(Serializable discoveredItem, ConfigurationItemDescriptor descriptor, String discoveredItemId, ConfigurationItemPropertyDescriptor eachPropertyDescriptor) {
        Object parent = this.getParent(discoveredItem, discoveredItemId, eachPropertyDescriptor);
        String parentId = this.getParentId(discoveredItemId, parent);
        String generatedId = JcrPathHelper.buildId(parentId, discoveredItemId);
        descriptor.setLabelValueInConfigurationItem(discoveredItem, generatedId);
    }

    private Object getParent(Serializable discoveredItem, String discoveredItemId, ConfigurationItemPropertyDescriptor eachPropertyDescriptor) {
        Object parent = eachPropertyDescriptor.getPropertyValueFromConfigurationItem(discoveredItem);
        if (parent == null) {
            throw new IllegalArgumentException("The discovered item " + discoveredItemId + " is not rooted and its parent is null");
        }
        if (!(parent instanceof Serializable)) {
            throw new IllegalArgumentException("The discovered item " + discoveredItemId + " is not rooted and its parent is not a Serializable");
        }
        return parent;
    }

    private String getParentId(String discoveredItemId, Object parent) {
        ConfigurationItemDescriptor parentDescriptor = this.repository.getDescriptorForObject((Serializable)parent);
        String parentId = parentDescriptor.getLabelValueFromConfigurationItem(parent);
        if (parentId == null) {
            throw new IllegalArgumentException("The discovered item " + discoveredItemId + " is not rooted and its parent does not have an id");
        }
        if (!parentId.contains("/")) {
            throw new IllegalArgumentException("The discovered item " + discoveredItemId + " is not rooted and its parent's id does not contain a slash");
        }
        return parentId;
    }
}

