/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.translation;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.MappingInfo;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.DeploymentPackage;
import com.xebialabs.deployit.ci.Environment;
import com.xebialabs.deployit.ci.MiddlewareResource;
import com.xebialabs.deployit.ci.artifact.DeployableArtifact;
import com.xebialabs.deployit.ci.mapping.KeyValuePair;
import com.xebialabs.deployit.ci.mapping.Mapping;
import com.xebialabs.deployit.exception.DeployitException;
import com.xebialabs.deployit.reflect.ConfigurationItemDescriptor;
import com.xebialabs.deployit.reflect.ConfigurationItemPropertyDescriptor;
import com.xebialabs.deployit.reflect.ConfigurationItemReflectionUtils;
import com.xebialabs.deployit.service.deployment.DeploymentService;
import com.xebialabs.deployit.typedescriptor.ConfigurationItemTypeDescriptorRepository;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.ReflectionUtils;

@Component
public class MappingGenerator {
    @Autowired
    private ConfigurationItemTypeDescriptorRepository repository;
    private static Field labelField;
    private static Field sourceField;
    private static Field targetField;

    public List<MappingInfo> generateMappingsForInitialDeployment(DeploymentPackage pkg, Environment env, String mappingType) {
        Deployment deployment = new Deployment(pkg, env);
        deployment.setLabel(DeploymentService.generateDeploymentLabel(pkg, env));
        ArrayList<MappingInfo> initialMappings = Lists.newArrayList();
        for (Serializable eachPkgMember : pkg.getAllMembers()) {
            List<MappingInfo> mappingsInfo = this.createInitialMappings(deployment, eachPkgMember, mappingType);
            initialMappings.addAll(mappingsInfo);
        }
        return initialMappings;
    }

    public List<MappingInfo> generateMappingsForUpgradeDeployment(Deployment d, DeploymentPackage newPkg) {
        ArrayList<MappingInfo> generatedMappingsForUpgrade = Lists.newArrayList();
        for (Mapping each : d.getMappings()) {
            MappingInfo generatedMappingForUpgrade = this.upgradeMapping(each, newPkg);
            if (generatedMappingForUpgrade == null) continue;
            generatedMappingsForUpgrade.add(generatedMappingForUpgrade);
        }
        return generatedMappingsForUpgrade;
    }

    private List<MappingInfo> createInitialMappings(Deployment deployment, Serializable pkgMember, String mappingType) {
        ArrayList<MappingInfo> mappingsCreated = Lists.newArrayList();
        for (Serializable eachEnvMember : deployment.getTarget().getMembers()) {
            ConfigurationItemDescriptor descriptor = mappingType == null ? this.findFirstMatchingMappingDescriptor(pkgMember, eachEnvMember) : this.getDescriptorIfMappingIsCompatible(pkgMember, eachEnvMember, mappingType);
            if (descriptor == null) continue;
            mappingsCreated.add(new MappingInfo(this.createMapping(deployment, pkgMember, eachEnvMember, descriptor), true));
        }
        return mappingsCreated;
    }

    private ConfigurationItemDescriptor findFirstMatchingMappingDescriptor(Serializable pkgMember, Serializable envMember) {
        List<String> allPkgMemberTypes = this.getAllTypes(pkgMember.getClass());
        List<String> allEnvMemberTypes = this.getAllTypes(envMember.getClass());
        for (ConfigurationItemDescriptor eachDescriptor : this.repository.getDescriptors()) {
            if (!this.isMappingDescriptor(eachDescriptor) || !allPkgMemberTypes.contains(eachDescriptor.getMappingSourceType()) || !allEnvMemberTypes.contains(eachDescriptor.getMappingTargetType())) continue;
            return eachDescriptor;
        }
        return null;
    }

    private ConfigurationItemDescriptor getDescriptorIfMappingIsCompatible(Serializable pkgMember, Serializable envMember, String mappingType) {
        ConfigurationItemDescriptor descriptor = this.repository.getDescriptorByShortName(mappingType);
        List<String> allPkgMemberTypes = this.getAllTypes(pkgMember.getClass());
        List<String> allEnvMemberTypes = this.getAllTypes(envMember.getClass());
        if (descriptor != null && this.isMappingDescriptor(descriptor) && allPkgMemberTypes.contains(descriptor.getMappingSourceType()) && allEnvMemberTypes.contains(descriptor.getMappingTargetType())) {
            return descriptor;
        }
        return null;
    }

    private Mapping<?, ?> createMapping(Deployment deployment, Serializable pkgMember, Serializable envMember, ConfigurationItemDescriptor descriptor) {
        Mapping mapping = (Mapping)descriptor.newInstance();
        String mappingLabel = this.generateMappingLabel(pkgMember, envMember);
        ReflectionUtils.setField(labelField, mapping, mappingLabel);
        ReflectionUtils.setField(sourceField, mapping, pkgMember);
        ReflectionUtils.setField(targetField, mapping, envMember);
        if (descriptor.getPlaceholdersField() != null) {
            ReflectionUtils.setField(descriptor.getPlaceholdersField(), mapping, this.generatePlaceholders(pkgMember));
        }
        mapping.postInit(deployment);
        return mapping;
    }

    private List<KeyValuePair> generatePlaceholders(Serializable pkgMember) {
        ConfigurationItemDescriptor descriptor = this.repository.getDescriptorForObject(pkgMember);
        ConfigurationItemPropertyDescriptor propertyDescriptor = descriptor.getPropertyDescriptor("placeholders");
        ArrayList<KeyValuePair> placeholders = new ArrayList<KeyValuePair>();
        if (propertyDescriptor != null) {
            Set placeholderSet = (Set)propertyDescriptor.getPropertyValueFromConfigurationItem(pkgMember);
            for (String placeholder : placeholderSet) {
                placeholders.add(new KeyValuePair(placeholder, null));
            }
        }
        return placeholders;
    }

    private MappingInfo upgradeMapping(Mapping<?, ?> mapping, DeploymentPackage pkg) {
        Object source = mapping.getSource();
        List<Serializable> similarObjects = this.findSimilarObject(pkg, (Serializable)source);
        if (similarObjects.size() == 0) {
            return new MappingInfo(this.cloneMapping(mapping, (Serializable)source), false);
        }
        if (similarObjects.size() == 1) {
            return new MappingInfo(this.cloneMapping(mapping, similarObjects.get(0)), true);
        }
        throw new DeployitException("Mapping " + mapping + " could not be upgraded since multiple similar items were found with the same identifying property value");
    }

    private Mapping<?, ?> cloneMapping(Mapping<?, ?> mapping, Serializable newSource) {
        Mapping clonedMapping = (Mapping)BeanUtils.instantiate(mapping.getClass());
        ConfigurationItemDescriptor descriptor = this.repository.getDescriptorByClass(mapping.getClass());
        BeanUtils.copyProperties(mapping, clonedMapping);
        clonedMapping.setSource(newSource);
        clonedMapping.setLabel(this.generateMappingLabel(newSource, (Serializable)clonedMapping.getTarget()));
        Field placeholdersField = descriptor.getPlaceholdersField();
        if (placeholdersField != null) {
            try {
                List<KeyValuePair> newPlaceholders = this.generatePlaceholders(newSource);
                List placeholders = (List)placeholdersField.get(clonedMapping);
                for (KeyValuePair newPlaceholder : newPlaceholders) {
                    KeyValuePair oldPlaceholder = this.getByKey(newPlaceholder.getKey(), placeholders);
                    if (oldPlaceholder == null) continue;
                    newPlaceholder.setValue(oldPlaceholder.getValue());
                }
                placeholdersField.set(clonedMapping, newPlaceholders);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Ask Jeroen", e);
            }
        }
        return clonedMapping;
    }

    private List<Serializable> findSimilarObject(DeploymentPackage pkg, Serializable source) {
        ArrayList<Serializable> similarObjects = Lists.newArrayList();
        for (MiddlewareResource middlewareResource : pkg.getMiddlewareResources()) {
            if (!ConfigurationItemReflectionUtils.isSimilar(middlewareResource, source)) continue;
            similarObjects.add(middlewareResource);
        }
        for (DeployableArtifact deployableArtifact : pkg.getDeployableArtifacts()) {
            if (!ConfigurationItemReflectionUtils.isSimilar(deployableArtifact, source)) continue;
            similarObjects.add(deployableArtifact);
        }
        return similarObjects;
    }

    private String generateMappingLabel(Serializable pkgMember, Serializable envMember) {
        String environmentMemberLabel = this.repository.getDescriptorForObject(envMember).getLabelValueFromConfigurationItem(envMember);
        return environmentMemberLabel + "/" + this.getIdentifier(pkgMember);
    }

    private String getIdentifier(Serializable object) {
        StringBuilder builder = new StringBuilder();
        ConfigurationItemDescriptor descriptor = this.repository.getDescriptorForObject(object);
        for (ConfigurationItemPropertyDescriptor propertyDescriptor : descriptor.getPropertyDescriptors()) {
            Object value;
            if (!propertyDescriptor.isIdentifying() || (value = propertyDescriptor.getPropertyValueFromConfigurationItem(object)) == null) continue;
            if (builder.length() > 0) {
                builder.append(":");
            }
            builder.append(value.toString().replace('/', '_'));
        }
        if (builder.length() == 0) {
            String ciLabel = descriptor.getLabelValueFromConfigurationItem(object);
            builder.append(ciLabel.substring(ciLabel.lastIndexOf("/") + 1));
        }
        return builder.toString();
    }

    private boolean isMappingDescriptor(ConfigurationItemDescriptor eachDescriptor) {
        return eachDescriptor.getSuperClasses().contains(Mapping.class.getName());
    }

    private List<String> getAllTypes(Class<?> clazz) {
        ConfigurationItemDescriptor desc = this.repository.getDescriptorByClass(clazz);
        Preconditions.checkNotNull(desc, "Cannnot find descriptor for " + clazz);
        return this.getAllTypesForDescriptor(desc);
    }

    private List<String> getAllTypesForDescriptor(ConfigurationItemDescriptor descriptor) {
        Preconditions.checkNotNull(descriptor);
        ArrayList<String> types = Lists.newArrayList();
        types.add(descriptor.getType());
        types.addAll(descriptor.getSuperClasses());
        types.addAll(descriptor.getInterfacesWithoutSerializable());
        return types;
    }

    private KeyValuePair getByKey(String key, List<KeyValuePair> placeHolders) {
        for (KeyValuePair keyValuePair : placeHolders) {
            if (!keyValuePair.getKey().equals(key)) continue;
            return keyValuePair;
        }
        return null;
    }

    static {
        try {
            labelField = BaseConfigurationItem.class.getDeclaredField("label");
            labelField.setAccessible(true);
            sourceField = Mapping.class.getDeclaredField("source");
            sourceField.setAccessible(true);
            targetField = Mapping.class.getDeclaredField("target");
            targetField.setAccessible(true);
        }
        catch (SecurityException e) {
            throw new Error(e);
        }
        catch (NoSuchFieldException e) {
            throw new Error(e);
        }
    }
}

