/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.util;

import com.xebialabs.deployit.ResolutionException;
import com.xebialabs.deployit.ci.artifact.War;
import com.xebialabs.deployit.ci.mapping.EjbReference;
import com.xebialabs.deployit.ci.mapping.ResourceReference;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WarFileInfoExtractor {
    public static List<ResourceReference> getResourceReferences(War war) {
        ArrayList<ResourceReference> resourceReferences = new ArrayList<ResourceReference>();
        NodeList resourceRefNodes = WarFileInfoExtractor.getNodesWithTag(war, "resource-ref");
        if (resourceRefNodes != null) {
            for (int i = 0; resourceRefNodes != null && i < resourceRefNodes.getLength(); ++i) {
                Element resourceRefNode = (Element)resourceRefNodes.item(i);
                String name = WarFileInfoExtractor.findName(resourceRefNode, "res-ref-name");
                String type = WarFileInfoExtractor.findName(resourceRefNode, "res-type");
                if (!StringUtils.isNotBlank(name)) continue;
                resourceReferences.add(new ResourceReference(name, type, ""));
            }
        }
        return resourceReferences;
    }

    public static List<ResourceReference> getResourceEnvironmentEntryReferences(War war) {
        ArrayList<ResourceReference> resourceEnvironmentReferences = new ArrayList<ResourceReference>();
        NodeList resourceEnvRefNodes = WarFileInfoExtractor.getNodesWithTag(war, "resource-env-ref");
        if (resourceEnvRefNodes != null) {
            for (int i = 0; resourceEnvRefNodes != null && i < resourceEnvRefNodes.getLength(); ++i) {
                Element resourceEnvRefNode = (Element)resourceEnvRefNodes.item(i);
                String name = WarFileInfoExtractor.findName(resourceEnvRefNode, "resource-env-ref-name");
                String type = WarFileInfoExtractor.findName(resourceEnvRefNode, "resource-env-ref-type");
                if (name == null || type == null) continue;
                resourceEnvironmentReferences.add(new ResourceReference(name, type, ""));
            }
        }
        return resourceEnvironmentReferences;
    }

    public static List<EjbReference> getEjbReferences(War war) {
        ArrayList<EjbReference> ejbReferencesAndLocals = new ArrayList<EjbReference>();
        NodeList ejbLocalRefNodes = WarFileInfoExtractor.getNodesWithTag(war, "ejb-local-ref");
        if (ejbLocalRefNodes != null) {
            for (int i = 0; i < ejbLocalRefNodes.getLength(); ++i) {
                Element ejbLocalRefNode = (Element)ejbLocalRefNodes.item(i);
                String name = WarFileInfoExtractor.findName(ejbLocalRefNode, "ejb-ref-name");
                String local = WarFileInfoExtractor.findName(ejbLocalRefNode, "local");
                if (name == null || local == null) continue;
                ejbReferencesAndLocals.add(new EjbReference(name, local, ""));
            }
        }
        return ejbReferencesAndLocals;
    }

    private static NodeList getNodesWithTag(War war, String tag) {
        NodeList nodeList;
        InputStream is;
        block5: {
            is = null;
            JarFile jarFile = new JarFile(new File(war.getLocation()));
            JarEntry jarEntry = jarFile.getJarEntry("WEB-INF/web.xml");
            if (jarEntry == null) break block5;
            is = jarFile.getInputStream(jarEntry);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            WarFileInfoExtractor.disableDtdValidation(db);
            Document doc = db.parse(new InputSource(is));
            NodeList resourceRefNodes = doc.getElementsByTagName(tag);
            is.close();
            jarFile.close();
            NodeList nodeList2 = resourceRefNodes;
            IOUtils.closeQuietly(is);
            return nodeList2;
        }
        try {
            nodeList = null;
        }
        catch (Exception e) {
            try {
                throw new ResolutionException("Problems occurred while trying to parse " + war.getName() + " for finding value of tag:" + tag + " (location " + war.getLocation() + ")", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(is);
        return nodeList;
    }

    private static String findName(Element element, String tagnameOfChild) {
        NodeList refNameElements = element.getElementsByTagName(tagnameOfChild);
        if (refNameElements.getLength() == 1) {
            Node refNameElement = refNameElements.item(0);
            return refNameElement.getFirstChild().getNodeValue();
        }
        return null;
    }

    private static void disableDtdValidation(DocumentBuilder db) {
        db.setEntityResolver(new EntityResolver(){

            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                System.out.println("Ignoring " + publicId + ", " + systemId);
                return new InputSource(new StringReader(""));
            }
        });
    }
}

