/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.util.zip;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public abstract class DateTimeConverter {
    static final long MIN_DOS_TIME = 0x210000L;
    public static final DateTimeConverter JAR;
    public static final DateTimeConverter ZIP;
    private final ThreadLocal calendar = new ThreadLocal(){
        static final /* synthetic */ boolean $assertionsDisabled;

        protected Object initialValue() {
            GregorianCalendar cal = new GregorianCalendar(DateTimeConverter.this.createTimeZone());
            boolean ea = false;
            if (!$assertionsDisabled) {
                ea = true;
                if (!true) {
                    throw new AssertionError();
                }
            }
            cal.setLenient(!ea);
            return cal;
        }

        static {
            $assertionsDisabled = !(class$de$schlichtherle$util$zip$DateTimeConverter == null ? (class$de$schlichtherle$util$zip$DateTimeConverter = DateTimeConverter.class$("de.schlichtherle.util.zip.DateTimeConverter")) : class$de$schlichtherle$util$zip$DateTimeConverter).desiredAssertionStatus();
        }
    };
    static final /* synthetic */ boolean $assertionsDisabled;

    final long toDosTime(long jTime) {
        if (jTime < 0L) {
            throw new IllegalArgumentException("Java time is negative: " + Long.toHexString(jTime));
        }
        Calendar cal = this.getCalendar();
        cal.setTimeInMillis(this.roundUp(jTime) ? jTime + 1999L : jTime);
        int year = cal.get(1) - 1980;
        if (year < 0) {
            return 0x210000L;
        }
        if (year > 127) {
            throw new IllegalArgumentException("Year of Java time is later than 2107 AD: " + (1980 + year));
        }
        long dTime = year << 25 | cal.get(2) + 1 << 21 | cal.get(5) << 16 | cal.get(11) << 11 | cal.get(12) << 5 | cal.get(13) >> 1;
        if (!$assertionsDisabled && dTime < 0x210000L) {
            throw new AssertionError();
        }
        return dTime;
    }

    final long toJavaTime(long dTime) {
        if (dTime < 0x210000L) {
            throw new IllegalArgumentException("DOS date/time is earlier than 1980 AD: " + Long.toHexString(dTime));
        }
        if (dTime > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("DOS date/time value is greater than " + Long.toHexString(0xFFFFFFFFL) + ": " + Long.toHexString(dTime));
        }
        int time = (int)dTime;
        Calendar cal = this.getCalendar();
        cal.set(1, 1980 + (time >> 25 & 0x7F));
        cal.set(2, (time >> 21 & 0xF) - 1);
        cal.set(5, time >> 16 & 0x1F);
        cal.set(11, time >> 11 & 0x1F);
        cal.set(12, time >> 5 & 0x3F);
        cal.set(13, time << 1 & 0x3E);
        cal.set(14, 0);
        return cal.getTimeInMillis();
    }

    private Calendar getCalendar() {
        return (Calendar)this.calendar.get();
    }

    protected abstract TimeZone createTimeZone();

    protected abstract boolean roundUp(long var1);

    static {
        $assertionsDisabled = !DateTimeConverter.class.desiredAssertionStatus();
        JAR = new DateTimeConverter(){

            protected TimeZone createTimeZone() {
                return TimeZone.getDefault();
            }

            protected boolean roundUp(long jTime) {
                return false;
            }
        };
        ZIP = new DateTimeConverter(){
            static final /* synthetic */ boolean $assertionsDisabled;

            protected TimeZone createTimeZone() {
                TimeZone tz = TimeZone.getDefault();
                tz = new SimpleTimeZone(tz.getRawOffset() + tz.getDSTSavings(), tz.getID());
                if (!$assertionsDisabled && tz.useDaylightTime()) {
                    throw new AssertionError();
                }
                return tz;
            }

            protected boolean roundUp(long jTime) {
                return true;
            }

            static {
                $assertionsDisabled = !(class$de$schlichtherle$util$zip$DateTimeConverter == null ? (class$de$schlichtherle$util$zip$DateTimeConverter = DateTimeConverter.class$("de.schlichtherle.util.zip.DateTimeConverter")) : class$de$schlichtherle$util$zip$DateTimeConverter).desiredAssertionStatus();
            }
        };
    }
}

