/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cff;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.fontbox.cff.CFFFont;
import org.apache.fontbox.cff.CIDKeyedFDSelect;
import org.apache.fontbox.cff.CharStringRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CFFFontROS
extends CFFFont {
    private String registry;
    private String ordering;
    private int supplement;
    private List<Map<String, Object>> fontDictionaries = new LinkedList<Map<String, Object>>();
    private List<Map<String, Object>> privateDictionaries = new LinkedList<Map<String, Object>>();
    private CIDKeyedFDSelect fdSelect = null;

    public String getRegistry() {
        return this.registry;
    }

    public void setRegistry(String registry) {
        this.registry = registry;
    }

    public String getOrdering() {
        return this.ordering;
    }

    public void setOrdering(String ordering) {
        this.ordering = ordering;
    }

    public int getSupplement() {
        return this.supplement;
    }

    public void setSupplement(int supplement) {
        this.supplement = supplement;
    }

    public List<Map<String, Object>> getFontDict() {
        return this.fontDictionaries;
    }

    public void setFontDict(List<Map<String, Object>> fontDict) {
        this.fontDictionaries = fontDict;
    }

    public List<Map<String, Object>> getPrivDict() {
        return this.privateDictionaries;
    }

    public void setPrivDict(List<Map<String, Object>> privDict) {
        this.privateDictionaries = privDict;
    }

    public CIDKeyedFDSelect getFdSelect() {
        return this.fdSelect;
    }

    public void setFdSelect(CIDKeyedFDSelect fdSelect) {
        this.fdSelect = fdSelect;
    }

    @Override
    public int getWidth(int SID2) throws IOException {
        int fdArrayIndex = this.fdSelect.getFd(SID2);
        if (fdArrayIndex == -1 && SID2 == 0) {
            return super.getWidth(SID2);
        }
        if (fdArrayIndex == -1) {
            return 1000;
        }
        Map<String, Object> fontDict = this.fontDictionaries.get(fdArrayIndex);
        Map<String, Object> privDict = this.privateDictionaries.get(fdArrayIndex);
        int nominalWidth = privDict.containsKey("nominalWidthX") ? ((Number)privDict.get("nominalWidthX")).intValue() : 0;
        int defaultWidth = privDict.containsKey("defaultWidthX") ? ((Number)privDict.get("defaultWidthX")).intValue() : 1000;
        for (CFFFont.Mapping m : this.getMappings()) {
            if (m.getSID() != SID2) continue;
            CharStringRenderer csr = null;
            Number charStringType = (Number)this.getProperty("CharstringType");
            if (charStringType.intValue() == 2) {
                List<Object> lSeq = m.toType2Sequence();
                csr = new CharStringRenderer(false);
                csr.render(lSeq);
            } else {
                List<Object> lSeq = m.toType1Sequence();
                csr = new CharStringRenderer();
                csr.render(lSeq);
            }
            return csr.getWidth() != 0 ? csr.getWidth() + nominalWidth : defaultWidth;
        }
        return defaultWidth;
    }
}

