/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.AccessDeniedException;
import javax.jcr.RepositoryException;
import javax.security.auth.Subject;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.jackrabbit.api.XASession;
import org.apache.jackrabbit.core.InternalXAResource;
import org.apache.jackrabbit.core.RepositoryContext;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.TransactionContext;
import org.apache.jackrabbit.core.WorkspaceImpl;
import org.apache.jackrabbit.core.config.WorkspaceConfig;
import org.apache.jackrabbit.core.lock.XALockManager;
import org.apache.jackrabbit.core.security.authentication.AuthContext;
import org.apache.jackrabbit.core.state.XAItemStateManager;
import org.apache.jackrabbit.core.version.InternalVersionManager;
import org.apache.jackrabbit.core.version.InternalXAVersionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XASessionImpl
extends SessionImpl
implements XASession,
XAResource {
    private static final Logger log = LoggerFactory.getLogger(XASessionImpl.class);
    private static final Map<Xid, TransactionContext> txGlobal = Collections.synchronizedMap(new HashMap());
    public static final String SYSTEM_PROPERTY_DEFAULT_TRANSACTION_TIMEOUT = "org.apache.jackrabbit.core.defaultTransactionTimeout";
    private static final int DEFAULT_TX_TIMEOUT = Integer.parseInt(System.getProperty("org.apache.jackrabbit.core.defaultTransactionTimeout", "5"));
    private TransactionContext tx;
    private int txTimeout;
    private InternalXAResource[] txResources;

    protected XASessionImpl(RepositoryContext repositoryContext, AuthContext loginContext, WorkspaceConfig wspConfig) throws AccessDeniedException, RepositoryException {
        super(repositoryContext, loginContext, wspConfig);
        this.init();
    }

    protected XASessionImpl(RepositoryContext repositoryContext, Subject subject, WorkspaceConfig wspConfig) throws AccessDeniedException, RepositoryException {
        super(repositoryContext, subject, wspConfig);
        this.init();
    }

    private void init() throws RepositoryException {
        WorkspaceImpl workspace = this.context.getWorkspace();
        XAItemStateManager stateMgr = (XAItemStateManager)workspace.getItemStateManager();
        XALockManager lockMgr = (XALockManager)workspace.getInternalLockManager();
        InternalXAVersionManager versionMgr = (InternalXAVersionManager)this.getInternalVersionManager();
        this.txResources = new InternalXAResource[]{versionMgr.getXAResourceBegin(), versionMgr, stateMgr, lockMgr, versionMgr.getXAResourceEnd()};
        stateMgr.setVirtualProvider(versionMgr);
    }

    protected InternalVersionManager createVersionManager() throws RepositoryException {
        return new InternalXAVersionManager(this.repositoryContext.getInternalVersionManager(), this.repositoryContext.getNodeTypeRegistry(), this, this.repositoryContext.getItemStateCacheFactory());
    }

    public XAResource getXAResource() {
        return this;
    }

    public int getTransactionTimeout() {
        return this.txTimeout == 0 ? DEFAULT_TX_TIMEOUT : this.txTimeout;
    }

    public boolean setTransactionTimeout(int seconds) {
        this.txTimeout = seconds;
        return true;
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        if (xares instanceof XASessionImpl) {
            XASessionImpl xases = (XASessionImpl)xares;
            return XASessionImpl.stringsEqual(this.userId, xases.userId);
        }
        return false;
    }

    public void start(Xid xid, int flags) throws XAException {
        if (this.isAssociated()) {
            log.error("Resource already associated with a transaction.");
            throw new XAException(-6);
        }
        TransactionContext tx = txGlobal.get(xid);
        if (flags == 0) {
            if (tx != null) {
                throw new XAException(-8);
            }
            tx = this.createTransaction(xid);
        } else if (flags == 0x200000) {
            if (tx == null) {
                throw new XAException(-4);
            }
        } else if (flags == 0x8000000) {
            if (tx == null) {
                throw new XAException(-4);
            }
            if (!tx.isSuspended()) {
                log.error("Unable to resume: transaction not suspended.");
                throw new XAException(-6);
            }
            tx.setSuspended(false);
        } else {
            throw new XAException(-5);
        }
        this.associate(tx);
    }

    private TransactionContext createTransaction(Xid xid) {
        TransactionContext tx = new TransactionContext(xid, this.txResources, this.getTransactionTimeout());
        txGlobal.put(xid, tx);
        return tx;
    }

    public void end(Xid xid, int flags) throws XAException {
        TransactionContext tx = txGlobal.get(xid);
        if (tx == null) {
            throw new XAException(-4);
        }
        if (flags == 0x2000000) {
            if (!this.isAssociated()) {
                log.error("Resource not associated with a transaction.");
                throw new XAException(-6);
            }
            this.associate(null);
            tx.setSuspended(true);
        } else if (flags == 0x20000000 || flags == 0x4000000) {
            if (!tx.isSuspended()) {
                if (!this.isAssociated()) {
                    log.error("Resource not associated with a transaction.");
                    throw new XAException(-6);
                }
                this.associate(null);
            } else {
                tx.setSuspended(false);
            }
        } else {
            throw new XAException(-5);
        }
    }

    public int prepare(Xid xid) throws XAException {
        TransactionContext tx = txGlobal.get(xid);
        if (tx == null) {
            throw new XAException(-4);
        }
        tx.prepare();
        return 0;
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        TransactionContext tx = txGlobal.get(xid);
        if (tx == null) {
            throw new XAException(-4);
        }
        if (onePhase) {
            tx.prepare();
        }
        tx.commit();
        txGlobal.remove(xid);
    }

    public void rollback(Xid xid) throws XAException {
        TransactionContext tx = txGlobal.get(xid);
        if (tx == null) {
            throw new XAException(-4);
        }
        tx.rollback();
        txGlobal.remove(xid);
    }

    public Xid[] recover(int flags) throws XAException {
        return new Xid[0];
    }

    public void forget(Xid xid) throws XAException {
    }

    public synchronized void associate(TransactionContext tx) {
        this.tx = tx;
        for (InternalXAResource txResource : this.txResources) {
            txResource.associate(tx);
        }
    }

    private boolean isAssociated() {
        return this.tx != null;
    }

    public synchronized void logout() {
        super.logout();
        try {
            ((InternalXAVersionManager)this.versionMgr).close();
        }
        catch (Exception e) {
            log.warn("error while closing InternalXAVersionManager", e);
        }
    }

    private static boolean stringsEqual(String s1, String s2) {
        if (s1 == null) {
            return s2 == null;
        }
        return s1.equals(s2);
    }
}

