/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.persistence.pool;

import javax.sql.DataSource;
import org.apache.jackrabbit.core.persistence.PMContext;
import org.apache.jackrabbit.core.persistence.pool.BundleDbPersistenceManager;
import org.apache.jackrabbit.core.util.db.ConnectionHelper;
import org.apache.jackrabbit.core.util.db.DerbyConnectionHelper;

public class DerbyPersistenceManager
extends BundleDbPersistenceManager {
    public static final String DERBY_EMBEDDED_DRIVER = "org.apache.derby.jdbc.EmbeddedDriver";
    private int derbyStorageInitialPages = 16;
    private int derbyStorageMinimumRecordSize = 512;
    private int derbyStoragePageCacheSize = 1024;
    private int derbyStoragePageReservedSpace = 20;
    private int derbyStoragePageSize = 16384;

    public String getDerbyStorageInitialPages() {
        return String.valueOf(this.derbyStorageInitialPages);
    }

    public void setDerbyStorageInitialPages(String derbyStorageInitialPages) {
        this.derbyStorageInitialPages = Integer.decode(derbyStorageInitialPages);
    }

    public String getDerbyStorageMinimumRecordSize() {
        return String.valueOf(this.derbyStorageMinimumRecordSize);
    }

    public void setDerbyStorageMinimumRecordSize(String derbyStorageMinimumRecordSize) {
        this.derbyStorageMinimumRecordSize = Integer.decode(derbyStorageMinimumRecordSize);
    }

    public String getDerbyStoragePageCacheSize() {
        return String.valueOf(this.derbyStoragePageCacheSize);
    }

    public void setDerbyStoragePageCacheSize(String derbyStoragePageCacheSize) {
        this.derbyStoragePageCacheSize = Integer.decode(derbyStoragePageCacheSize);
    }

    public String getDerbyStoragePageReservedSpace() {
        return String.valueOf(this.derbyStoragePageReservedSpace);
    }

    public void setDerbyStoragePageReservedSpace(String derbyStoragePageReservedSpace) {
        this.derbyStoragePageReservedSpace = Integer.decode(derbyStoragePageReservedSpace);
    }

    public String getDerbyStoragePageSize() {
        return String.valueOf(this.derbyStoragePageSize);
    }

    public void setDerbyStoragePageSize(String derbyStoragePageSize) {
        this.derbyStoragePageSize = Integer.decode(derbyStoragePageSize);
    }

    public void init(PMContext context) throws Exception {
        if (this.getDriver() == null) {
            this.setDriver(DERBY_EMBEDDED_DRIVER);
        }
        if (this.getDatabaseType() == null) {
            this.setDatabaseType("derby");
        }
        if (this.getUrl() == null) {
            this.setUrl("jdbc:derby:" + context.getHomeDir().getPath() + "/db/itemState;create=true");
        }
        if (this.getSchemaObjectPrefix() == null) {
            this.setSchemaObjectPrefix("");
        }
        super.init(context);
        if (DERBY_EMBEDDED_DRIVER.equals(this.getDriver())) {
            this.conHelper.exec("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY ('derby.storage.initialPages', '" + this.derbyStorageInitialPages + "')", new Object[0]);
            this.conHelper.exec("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY ('derby.storage.minimumRecordSize', '" + this.derbyStorageMinimumRecordSize + "')", new Object[0]);
            this.conHelper.exec("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY ('derby.storage.pageCacheSize', '" + this.derbyStoragePageCacheSize + "')", new Object[0]);
            this.conHelper.exec("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY ('derby.storage.pageReservedSpace', '" + this.derbyStoragePageReservedSpace + "')", new Object[0]);
            this.conHelper.exec("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY ('derby.storage.pageSize', '" + this.derbyStoragePageSize + "')", new Object[0]);
        }
    }

    protected ConnectionHelper createConnectionHelper(DataSource dataSrc) {
        return new DerbyConnectionHelper(dataSrc, this.blockOnConnectionLoss);
    }

    public int getStorageModel() {
        return 2;
    }

    public void close() throws Exception {
        super.close();
        ((DerbyConnectionHelper)this.conHelper).shutDown(this.getDriver());
    }
}

