/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.jackrabbit.core.query.lucene.DateField;
import org.apache.jackrabbit.core.query.lucene.DecimalField;
import org.apache.jackrabbit.core.query.lucene.DoubleField;
import org.apache.jackrabbit.core.query.lucene.IndexFormatVersion;
import org.apache.jackrabbit.core.query.lucene.LongField;
import org.apache.jackrabbit.core.query.lucene.PropertyMetaData;
import org.apache.jackrabbit.core.query.lucene.ReadOnlyIndexReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.search.SortComparatorSource;

public class SharedFieldCache {
    public static final SharedFieldCache INSTANCE = new SharedFieldCache();
    private final Map<IndexReader, Map<Key, ValueIndex>> cache = new WeakHashMap<IndexReader, Map<Key, ValueIndex>>();

    private SharedFieldCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValueIndex getValueIndex(IndexReader reader, String field, String prefix, SortComparatorSource comparator) throws IOException {
        ValueIndex ret;
        if (reader instanceof ReadOnlyIndexReader) {
            reader = ((ReadOnlyIndexReader)reader).getBase();
        }
        if ((ret = this.lookup(reader, field = field.intern(), prefix, comparator)) == null) {
            Comparable[] retArray = new Comparable[reader.maxDoc()];
            int setValues = 0;
            if (retArray.length > 0) {
                TermDocs termDocs;
                IndexFormatVersion version = IndexFormatVersion.getVersion(reader);
                boolean hasPayloads = version.isAtLeast(IndexFormatVersion.V3);
                byte[] payload = null;
                if (hasPayloads) {
                    termDocs = reader.termPositions();
                    payload = new byte[1];
                } else {
                    termDocs = reader.termDocs();
                }
                TermEnum termEnum = reader.terms(new Term(field, prefix));
                char[] tmp = new char[16];
                try {
                    Term term;
                    if (termEnum.term() == null) {
                        throw new RuntimeException("no terms in field " + field);
                    }
                    while ((term = termEnum.term()).field() == field) {
                        if (!term.text().startsWith(prefix)) {
                        } else {
                            String text = term.text();
                            int len = text.length() - prefix.length();
                            if (tmp.length < len) {
                                tmp = new char[len];
                            }
                            text.getChars(prefix.length(), text.length(), tmp, 0);
                            String value = new String(tmp, 0, len);
                            termDocs.seek(termEnum);
                            while (termDocs.next()) {
                                int type = 0;
                                if (hasPayloads) {
                                    TermPositions termPos = (TermPositions)termDocs;
                                    termPos.nextPosition();
                                    if (termPos.isPayloadAvailable()) {
                                        payload = termPos.getPayload(payload, 0);
                                        type = PropertyMetaData.fromByteArray(payload).getPropertyType();
                                    }
                                }
                                ++setValues;
                                retArray[termDocs.doc()] = this.getValue(value, type);
                            }
                            if (termEnum.next()) continue;
                        }
                        break;
                    }
                }
                finally {
                    termDocs.close();
                    termEnum.close();
                }
            }
            ValueIndex value = new ValueIndex(retArray, setValues);
            this.store(reader, field, prefix, comparator, value);
            return value;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ValueIndex lookup(IndexReader reader, String field, String prefix, SortComparatorSource comparer) {
        Key key = new Key(field, prefix, comparer);
        SharedFieldCache sharedFieldCache = this;
        synchronized (sharedFieldCache) {
            Map<Key, ValueIndex> readerCache = this.cache.get(reader);
            if (readerCache == null) {
                return null;
            }
            return readerCache.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ValueIndex store(IndexReader reader, String field, String prefix, SortComparatorSource comparer, ValueIndex value) {
        Key key = new Key(field, prefix, comparer);
        SharedFieldCache sharedFieldCache = this;
        synchronized (sharedFieldCache) {
            Map<Key, ValueIndex> readerCache = this.cache.get(reader);
            if (readerCache == null) {
                readerCache = new HashMap<Key, ValueIndex>();
                this.cache.put(reader, readerCache);
            }
            return readerCache.put(key, value);
        }
    }

    private Comparable getValue(String value, int type) {
        switch (type) {
            case 6: {
                return Boolean.valueOf(value);
            }
            case 5: {
                return Long.valueOf(DateField.stringToTime(value));
            }
            case 3: {
                return Long.valueOf(LongField.stringToLong(value));
            }
            case 4: {
                return Double.valueOf(DoubleField.stringToDouble(value));
            }
            case 12: {
                return DecimalField.stringToDecimal(value);
            }
        }
        return value;
    }

    static class Key {
        private final String field;
        private final String prefix;
        private final SortComparatorSource comparator;

        Key(String field, String prefix, SortComparatorSource comparator) {
            this.field = field.intern();
            this.prefix = prefix.intern();
            this.comparator = comparator;
        }

        public boolean equals(Object o) {
            if (o instanceof Key) {
                Key other = (Key)o;
                return other.field == this.field && other.prefix == this.prefix && other.comparator.equals(this.comparator);
            }
            return false;
        }

        public int hashCode() {
            return this.field.hashCode() ^ this.prefix.hashCode() ^ this.comparator.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ValueIndex {
        private static final int SPARSE_FACTOR = 100;
        private final Comparable[] values;
        public final Map<Integer, Comparable> valuesMap;
        public final boolean sparse;

        public ValueIndex(Comparable[] values, int setValues) {
            if (this.isSparse(values, setValues)) {
                this.sparse = true;
                this.values = null;
                this.valuesMap = setValues == 0 ? null : this.getValuesMap(values, setValues);
            } else {
                this.sparse = false;
                this.values = values;
                this.valuesMap = null;
            }
        }

        public Comparable getValue(int i) {
            if (this.sparse) {
                return this.valuesMap == null ? null : this.valuesMap.get(i);
            }
            return this.values[i];
        }

        private Map<Integer, Comparable> getValuesMap(Comparable[] values, int setValues) {
            HashMap<Integer, Comparable> map = new HashMap<Integer, Comparable>(setValues);
            for (int i = 0; i < values.length && setValues > 0; ++i) {
                if (values[i] == null) continue;
                map.put(i, values[i]);
                --setValues;
            }
            return map;
        }

        private boolean isSparse(Comparable[] values, int setValues) {
            return setValues * 100 < values.length;
        }
    }
}

