/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene.join;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.Workspace;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import javax.jcr.query.qom.Column;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.DynamicOperand;
import javax.jcr.query.qom.Join;
import javax.jcr.query.qom.Ordering;
import javax.jcr.query.qom.PropertyValue;
import javax.jcr.query.qom.QueryObjectModelFactory;
import javax.jcr.query.qom.Selector;
import javax.jcr.query.qom.Source;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.jackrabbit.commons.iterator.RowIteratorAdapter;
import org.apache.jackrabbit.core.query.lucene.LuceneQueryFactory;
import org.apache.jackrabbit.core.query.lucene.join.ConstraintSplitter;
import org.apache.jackrabbit.core.query.lucene.join.Constraints;
import org.apache.jackrabbit.core.query.lucene.join.JoinMerger;
import org.apache.jackrabbit.core.query.lucene.join.OperandEvaluator;
import org.apache.jackrabbit.core.query.lucene.join.SimpleQueryResult;
import org.apache.jackrabbit.core.query.lucene.join.ValueComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryEngine {
    private final LuceneQueryFactory lqf;
    private final NodeTypeManager ntManager;
    private final QueryObjectModelFactory qomFactory;
    private final ValueFactory valueFactory;
    private final OperandEvaluator evaluator;

    public QueryEngine(Session session, LuceneQueryFactory lqf, Map<String, Value> variables) throws RepositoryException {
        this.lqf = lqf;
        Workspace workspace = session.getWorkspace();
        this.ntManager = workspace.getNodeTypeManager();
        this.qomFactory = workspace.getQueryManager().getQOMFactory();
        this.valueFactory = session.getValueFactory();
        this.evaluator = new OperandEvaluator(this.valueFactory, variables);
    }

    public QueryResult execute(Column[] columns, Source source, Constraint constraint, Ordering[] orderings, long offset, long limit) throws RepositoryException {
        if (source instanceof Selector) {
            Selector selector = (Selector)source;
            return this.execute(columns, selector, constraint, orderings, offset, limit);
        }
        if (source instanceof Join) {
            Join join = (Join)source;
            if (join.getJoinType() == "jcr.join.type.right.outer") {
                join = this.qomFactory.join(join.getRight(), join.getLeft(), "jcr.join.type.left.outer", join.getJoinCondition());
            }
            return this.execute(columns, join, constraint, orderings, offset, limit);
        }
        throw new UnsupportedRepositoryOperationException("Unknown source type: " + source);
    }

    protected QueryResult execute(Column[] columns, Join join, Constraint constraint, Ordering[] orderings, long offset, long limit) throws RepositoryException {
        RowIterator rightRows;
        JoinMerger merger = JoinMerger.getJoinMerger(join, this.getColumnMap(columns, this.getSelectorNames(join)), this.evaluator, this.qomFactory);
        ConstraintSplitter splitter = new ConstraintSplitter(constraint, this.qomFactory, merger.getLeftSelectors(), merger.getRightSelectors());
        Source left = join.getLeft();
        Constraint leftConstraint = splitter.getLeftConstraint();
        QueryResult leftResult = this.execute(null, left, leftConstraint, null, 0L, -1L);
        ArrayList<Row> leftRows = new ArrayList<Row>();
        for (Row row : JcrUtils.getRows(leftResult)) {
            leftRows.add(row);
        }
        Source right = join.getRight();
        List<Constraint> rightConstraints = merger.getRightJoinConstraints(leftRows);
        if (rightConstraints.size() < 500) {
            Constraint rightConstraint = Constraints.and(this.qomFactory, Constraints.or(this.qomFactory, rightConstraints), splitter.getRightConstraint());
            rightRows = this.execute(null, right, rightConstraint, null, 0L, -1L).getRows();
        } else {
            ArrayList<Row> list = new ArrayList<Row>();
            for (int i = 0; i < rightConstraints.size(); i += 500) {
                Constraint rightConstraint = Constraints.and(this.qomFactory, Constraints.or(this.qomFactory, rightConstraints.subList(i, Math.min(i + 500, rightConstraints.size()))), splitter.getRightConstraint());
                QueryResult rigthResult = this.execute(null, right, rightConstraint, null, 0L, -1L);
                for (Row row : JcrUtils.getRows(rigthResult)) {
                    list.add(row);
                }
            }
            rightRows = new RowIteratorAdapter(list);
        }
        QueryResult result = merger.merge(new RowIteratorAdapter(leftRows), rightRows);
        return this.sort(result, orderings, offset, limit);
    }

    protected QueryResult execute(Column[] columns, Selector selector, Constraint constraint, Ordering[] orderings, long offset, long limit) throws RepositoryException {
        Map<String, NodeType> selectorMap = this.getSelectorNames(selector);
        String[] selectorNames = selectorMap.keySet().toArray(new String[selectorMap.size()]);
        Map<String, PropertyValue> columnMap = this.getColumnMap(columns, selectorMap);
        String[] columnNames = columnMap.keySet().toArray(new String[columnMap.size()]);
        try {
            RowIteratorAdapter rows = new RowIteratorAdapter(this.lqf.execute(columnMap, selector, constraint));
            SimpleQueryResult result = new SimpleQueryResult(columnNames, selectorNames, rows);
            return this.sort(result, orderings, offset, limit);
        }
        catch (IOException e) {
            throw new RepositoryException("Failed to access the query index", e);
        }
    }

    private Map<String, PropertyValue> getColumnMap(Column[] columns, Map<String, NodeType> selectors) throws RepositoryException {
        LinkedHashMap<String, PropertyValue> map = new LinkedHashMap<String, PropertyValue>();
        if (columns != null && columns.length > 0) {
            for (int i = 0; i < columns.length; ++i) {
                String name = columns[i].getColumnName();
                if (name != null) {
                    map.put(name, this.qomFactory.propertyValue(columns[i].getSelectorName(), columns[i].getPropertyName()));
                    continue;
                }
                String selector = columns[i].getSelectorName();
                map.putAll(this.getColumnMap(selector, selectors.get(selector)));
            }
        } else {
            for (Map.Entry<String, NodeType> selector : selectors.entrySet()) {
                map.putAll(this.getColumnMap(selector.getKey(), selector.getValue()));
            }
        }
        return map;
    }

    private Map<String, PropertyValue> getColumnMap(String selector, NodeType type) throws RepositoryException {
        LinkedHashMap<String, PropertyValue> map = new LinkedHashMap<String, PropertyValue>();
        for (PropertyDefinition definition : type.getPropertyDefinitions()) {
            String name = definition.getName();
            if (definition.isMultiple() || "*".equals(name)) continue;
            map.put(selector + "." + name, this.qomFactory.propertyValue(selector, name));
        }
        return map;
    }

    private Map<String, NodeType> getSelectorNames(Source source) throws RepositoryException {
        if (source instanceof Selector) {
            Selector selector = (Selector)source;
            return Collections.singletonMap(selector.getSelectorName(), this.getNodeType(selector));
        }
        if (source instanceof Join) {
            Join join = (Join)source;
            LinkedHashMap<String, NodeType> map = new LinkedHashMap<String, NodeType>();
            map.putAll(this.getSelectorNames(join.getLeft()));
            map.putAll(this.getSelectorNames(join.getRight()));
            return map;
        }
        throw new UnsupportedRepositoryOperationException("Unknown source type: " + source);
    }

    private NodeType getNodeType(Selector selector) throws RepositoryException {
        try {
            return this.ntManager.getNodeType(selector.getNodeTypeName());
        }
        catch (NoSuchNodeTypeException e) {
            throw new InvalidQueryException("Selected node type does not exist: " + selector, e);
        }
    }

    public QueryResult sort(QueryResult result, Ordering[] orderings, long offset, long limit) throws RepositoryException {
        if (orderings != null && orderings.length > 0 || offset != 0L || limit >= 0L) {
            int size;
            List<Row> rows = new ArrayList<Row>();
            RowIterator iterator = result.getRows();
            while (iterator.hasNext()) {
                rows.add(iterator.nextRow());
            }
            if (orderings != null && orderings.length > 0) {
                Collections.sort(rows, new RowComparator(orderings));
            }
            if (offset > 0L) {
                size = rows.size();
                rows = rows.subList((int)Math.min(offset, (long)size), size);
            }
            if (limit >= 0L) {
                size = rows.size();
                rows = rows.subList(0, (int)Math.min(limit, (long)size));
            }
            return new SimpleQueryResult(result.getColumnNames(), result.getSelectorNames(), new RowIteratorAdapter(rows));
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RowComparator
    implements Comparator<Row> {
        private final ValueComparator comparator = new ValueComparator();
        private final Ordering[] orderings;

        private RowComparator(Ordering[] orderings) {
            this.orderings = orderings;
        }

        @Override
        public int compare(Row a, Row b) {
            try {
                for (Ordering ordering : this.orderings) {
                    Value[] vb;
                    DynamicOperand operand = ordering.getOperand();
                    Value[] va = QueryEngine.this.evaluator.getValues(operand, a);
                    int d = this.compare(va, vb = QueryEngine.this.evaluator.getValues(operand, b));
                    if (d == 0) continue;
                    if ("jcr.order.descending".equals(ordering.getOrder())) {
                        return -d;
                    }
                    return d;
                }
                return 0;
            }
            catch (RepositoryException e) {
                throw new RuntimeException("Unable to compare rows " + a + " and " + b, e);
            }
        }

        @Override
        private int compare(Value[] a, Value[] b) {
            for (int i = 0; i < a.length && i < b.length; ++i) {
                int d = this.comparator.compare(a[i], b[i]);
                if (d == 0) continue;
                return d;
            }
            return a.length - b.length;
        }
    }
}

