/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authorization.acl;

import java.security.acl.Group;
import java.util.Collection;
import java.util.List;
import javax.jcr.NamespaceException;
import javax.jcr.security.AccessControlEntry;
import org.apache.jackrabbit.core.security.authorization.acl.ACLTemplate;
import org.apache.jackrabbit.core.security.authorization.acl.EntryFilter;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.PathResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EntryFilterImpl
implements EntryFilter {
    private static final Logger log = LoggerFactory.getLogger(EntryFilterImpl.class);
    private final Collection<String> principalNames;
    private final Path path;
    private final PathResolver resolver;
    private String itemPath;

    EntryFilterImpl(Collection<String> principalNames, Path path, PathResolver resolver) {
        this.principalNames = principalNames;
        this.path = path;
        this.resolver = resolver;
    }

    @Override
    public void filterEntries(List<AccessControlEntry> entries, List<AccessControlEntry> ... resultLists) {
        if (resultLists.length == 2) {
            List<AccessControlEntry> userAces = resultLists[0];
            List<AccessControlEntry> groupAces = resultLists[1];
            int uInsertIndex = userAces.size();
            int gInsertIndex = groupAces.size();
            for (AccessControlEntry ace : entries) {
                if (!this.matches(ace)) continue;
                if (ace.getPrincipal() instanceof Group) {
                    groupAces.add(gInsertIndex, ace);
                    continue;
                }
                userAces.add(uInsertIndex, ace);
            }
        } else {
            log.warn("Filtering aborted. Expected 2 result lists.");
        }
    }

    private boolean matches(AccessControlEntry ace) {
        if (this.principalNames == null || this.principalNames.contains(ace.getPrincipal().getName())) {
            if (((ACLTemplate.Entry)ace).getRestrictions().isEmpty()) {
                return true;
            }
            try {
                return ((ACLTemplate.Entry)ace).matches(this.getPath());
            }
            catch (NamespaceException e) {
                log.error("Cannot determine ACE match.", e);
            }
        }
        return false;
    }

    String getPath() throws NamespaceException {
        if (this.itemPath == null) {
            this.itemPath = this.resolver.getJCRPath(this.path);
        }
        return this.itemPath;
    }
}

