/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.extractor;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.poi.POIOLE2TextExtractor;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.hwpf.model.TextPiece;
import org.apache.poi.hwpf.usermodel.HeaderStories;
import org.apache.poi.hwpf.usermodel.Paragraph;
import org.apache.poi.hwpf.usermodel.Range;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public final class WordExtractor
extends POIOLE2TextExtractor {
    private POIFSFileSystem fs;
    private HWPFDocument doc;

    public WordExtractor(InputStream is) throws IOException {
        this(HWPFDocument.verifyAndBuildPOIFS(is));
    }

    public WordExtractor(POIFSFileSystem fs) throws IOException {
        this(new HWPFDocument(fs));
        this.fs = fs;
    }

    public WordExtractor(DirectoryNode dir, POIFSFileSystem fs) throws IOException {
        this(new HWPFDocument(dir, fs));
        this.fs = fs;
    }

    public WordExtractor(HWPFDocument doc) {
        super(doc);
        this.doc = doc;
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.err.println("Use:");
            System.err.println("   java org.apache.poi.hwpf.extractor.WordExtractor <filename>");
            System.exit(1);
        }
        FileInputStream fin = new FileInputStream(args[0]);
        WordExtractor extractor = new WordExtractor(fin);
        System.out.println(extractor.getText());
    }

    public String[] getParagraphText() {
        String[] ret;
        try {
            Range r = this.doc.getRange();
            ret = WordExtractor.getParagraphText(r);
        }
        catch (Exception e) {
            ret = new String[]{this.getTextFromPieces()};
        }
        return ret;
    }

    public String[] getFootnoteText() {
        Range r = this.doc.getFootnoteRange();
        return WordExtractor.getParagraphText(r);
    }

    public String[] getEndnoteText() {
        Range r = this.doc.getEndnoteRange();
        return WordExtractor.getParagraphText(r);
    }

    public String[] getCommentsText() {
        Range r = this.doc.getCommentsRange();
        return WordExtractor.getParagraphText(r);
    }

    protected static String[] getParagraphText(Range r) {
        String[] ret = new String[r.numParagraphs()];
        for (int i = 0; i < ret.length; ++i) {
            Paragraph p = r.getParagraph(i);
            ret[i] = p.text();
            if (!ret[i].endsWith("\r")) continue;
            ret[i] = ret[i] + "\n";
        }
        return ret;
    }

    private void appendHeaderFooter(String text, StringBuffer out) {
        if (text == null || text.length() == 0) {
            return;
        }
        if (!(text = text.replace('\r', '\n')).endsWith("\n")) {
            out.append(text);
            out.append('\n');
            return;
        }
        if (text.endsWith("\n\n")) {
            out.append(text.substring(0, text.length() - 1));
            return;
        }
        out.append(text);
    }

    public String getHeaderText() {
        HeaderStories hs = new HeaderStories(this.doc);
        StringBuffer ret = new StringBuffer();
        if (hs.getFirstHeader() != null) {
            this.appendHeaderFooter(hs.getFirstHeader(), ret);
        }
        if (hs.getEvenHeader() != null) {
            this.appendHeaderFooter(hs.getEvenHeader(), ret);
        }
        if (hs.getOddHeader() != null) {
            this.appendHeaderFooter(hs.getOddHeader(), ret);
        }
        return ret.toString();
    }

    public String getFooterText() {
        HeaderStories hs = new HeaderStories(this.doc);
        StringBuffer ret = new StringBuffer();
        if (hs.getFirstFooter() != null) {
            this.appendHeaderFooter(hs.getFirstFooter(), ret);
        }
        if (hs.getEvenFooter() != null) {
            this.appendHeaderFooter(hs.getEvenFooter(), ret);
        }
        if (hs.getOddFooter() != null) {
            this.appendHeaderFooter(hs.getOddFooter(), ret);
        }
        return ret.toString();
    }

    public String getTextFromPieces() {
        StringBuffer textBuf = new StringBuffer();
        for (TextPiece piece : this.doc.getTextTable().getTextPieces()) {
            String encoding = "Cp1252";
            if (piece.isUnicode()) {
                encoding = "UTF-16LE";
            }
            try {
                String text = new String(piece.getRawBytes(), encoding);
                textBuf.append(text);
            }
            catch (UnsupportedEncodingException e) {
                throw new InternalError("Standard Encoding " + encoding + " not found, JVM broken");
            }
        }
        String text = textBuf.toString();
        text = text.replaceAll("\r\r\r", "\r\n\r\n\r\n");
        if ((text = text.replaceAll("\r\r", "\r\n\r\n")).endsWith("\r")) {
            text = text + "\n";
        }
        return text;
    }

    public String getText() {
        StringBuffer ret = new StringBuffer();
        ret.append(this.getHeaderText());
        ArrayList<String> text = new ArrayList<String>();
        text.addAll(Arrays.asList(this.getParagraphText()));
        text.addAll(Arrays.asList(this.getFootnoteText()));
        text.addAll(Arrays.asList(this.getEndnoteText()));
        for (String p : text) {
            ret.append(p);
        }
        ret.append(this.getFooterText());
        return ret.toString();
    }

    public static String stripFields(String text) {
        return Range.stripFields(text);
    }
}

