/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.core.AbstractAsynchronousResponse;
import org.jboss.resteasy.core.MessageBodyParameterInjector;
import org.jboss.resteasy.core.ResourceInvoker;
import org.jboss.resteasy.core.ServerResponse;
import org.jboss.resteasy.core.ValueInjector;
import org.jboss.resteasy.core.interception.InterceptorRegistry;
import org.jboss.resteasy.core.interception.InterceptorRegistryListener;
import org.jboss.resteasy.specimpl.UriInfoImpl;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.InjectorFactory;
import org.jboss.resteasy.spi.MethodInjector;
import org.jboss.resteasy.spi.ResourceFactory;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.interception.MessageBodyWriterInterceptor;
import org.jboss.resteasy.spi.interception.PostProcessInterceptor;
import org.jboss.resteasy.spi.interception.PreProcessInterceptor;
import org.jboss.resteasy.util.Types;
import org.jboss.resteasy.util.WeightedMediaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceMethod
implements ResourceInvoker,
InterceptorRegistryListener {
    protected MediaType[] produces;
    protected MediaType[] consumes;
    protected List<WeightedMediaType> preferredProduces = new ArrayList<WeightedMediaType>();
    protected List<WeightedMediaType> preferredConsumes = new ArrayList<WeightedMediaType>();
    protected Set<String> httpMethods;
    protected MethodInjector methodInjector;
    protected InjectorFactory injector;
    protected ResourceFactory resource;
    protected ResteasyProviderFactory providerFactory;
    protected Method method;
    protected Class<?> resourceClass;
    protected PreProcessInterceptor[] preProcessInterceptors;
    protected PostProcessInterceptor[] postProcessInterceptors;
    protected MessageBodyWriterInterceptor[] writerInterceptors;
    protected ConcurrentHashMap<String, AtomicLong> stats = new ConcurrentHashMap();
    protected Type genericReturnType;

    public ResourceMethod(Class<?> clazz, Method method, InjectorFactory injector, ResourceFactory resource, ResteasyProviderFactory providerFactory, Set<String> httpMethods) {
        int i;
        Consumes c;
        this.injector = injector;
        this.resource = resource;
        this.providerFactory = providerFactory;
        this.httpMethods = httpMethods;
        this.resourceClass = clazz;
        this.method = method;
        this.methodInjector = injector.createMethodInjector(clazz, method);
        Produces p = method.getAnnotation(Produces.class);
        if (p == null) {
            p = clazz.getAnnotation(Produces.class);
        }
        if ((c = method.getAnnotation(Consumes.class)) == null) {
            c = clazz.getAnnotation(Consumes.class);
        }
        if (p != null) {
            this.produces = new MediaType[p.value().length];
            i = 0;
            for (String mediaType : p.value()) {
                this.produces[i++] = MediaType.valueOf(mediaType);
                this.preferredProduces.add(WeightedMediaType.valueOf(mediaType));
            }
        }
        if (c != null) {
            this.consumes = new MediaType[c.value().length];
            i = 0;
            for (String mediaType : c.value()) {
                this.consumes[i++] = MediaType.valueOf(mediaType);
                this.preferredConsumes.add(WeightedMediaType.valueOf(mediaType));
            }
        }
        Collections.sort(this.preferredProduces);
        Collections.sort(this.preferredConsumes);
        this.preProcessInterceptors = providerFactory.getServerPreProcessInterceptorRegistry().bind(this.resourceClass, method);
        this.postProcessInterceptors = providerFactory.getServerPostProcessInterceptorRegistry().bind(this.resourceClass, method);
        this.writerInterceptors = providerFactory.getServerMessageBodyWriterInterceptorRegistry().bind(this.resourceClass, method);
        providerFactory.getServerPreProcessInterceptorRegistry().getListeners().add(this);
        providerFactory.getServerPostProcessInterceptorRegistry().getListeners().add(this);
        providerFactory.getServerMessageBodyWriterInterceptorRegistry().getListeners().add(this);
        this.genericReturnType = Types.getGenericReturnTypeOfGenericInterfaceMethod(clazz, method);
    }

    public void cleanup() {
        this.providerFactory.getServerPreProcessInterceptorRegistry().getListeners().remove(this);
        this.providerFactory.getServerPostProcessInterceptorRegistry().getListeners().remove(this);
        this.providerFactory.getServerMessageBodyWriterInterceptorRegistry().getListeners().remove(this);
        for (ValueInjector param : this.methodInjector.getParams()) {
            if (!(param instanceof MessageBodyParameterInjector)) continue;
            this.providerFactory.getServerMessageBodyReaderInterceptorRegistry().getListeners().remove(param);
        }
    }

    @Override
    public void registryUpdated(InterceptorRegistry registry) {
        if (registry.getIntf().equals(MessageBodyWriterInterceptor.class)) {
            this.writerInterceptors = this.providerFactory.getServerMessageBodyWriterInterceptorRegistry().bind(this.resourceClass, this.method);
        } else if (registry.getIntf().equals(PreProcessInterceptor.class)) {
            this.preProcessInterceptors = this.providerFactory.getServerPreProcessInterceptorRegistry().bind(this.resourceClass, this.method);
        } else if (registry.getIntf().equals(PostProcessInterceptor.class)) {
            this.postProcessInterceptors = this.providerFactory.getServerPostProcessInterceptorRegistry().bind(this.resourceClass, this.method);
        }
    }

    protected void incrementMethodCount(String httpMethod) {
        AtomicLong old;
        AtomicLong stat = this.stats.get(httpMethod);
        if (stat == null && (old = this.stats.putIfAbsent(httpMethod, stat = new AtomicLong())) != null) {
            stat = old;
        }
        stat.incrementAndGet();
    }

    public Map<String, AtomicLong> getStats() {
        return this.stats;
    }

    public Class<?> getResourceClass() {
        return this.resourceClass;
    }

    public List<WeightedMediaType> getPreferredProduces() {
        return this.preferredProduces;
    }

    public List<WeightedMediaType> getPreferredConsumes() {
        return this.preferredConsumes;
    }

    public Method getMethod() {
        return this.method;
    }

    @Override
    public ServerResponse invoke(HttpRequest request, HttpResponse response) {
        Object target = this.resource.createResource(request, response, this.injector);
        return this.invoke(request, response, target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServerResponse invoke(HttpRequest request, HttpResponse response, Object target) {
        request.setAttribute(ResourceMethod.class.getName(), this);
        this.incrementMethodCount(request.getHttpMethod());
        UriInfoImpl uriInfo = (UriInfoImpl)request.getUri();
        uriInfo.pushCurrentResource(target);
        try {
            Object type;
            ServerResponse jaxrsResponse = this.invokeOnTarget(request, response, target);
            if (jaxrsResponse != null && jaxrsResponse.getEntity() != null && (type = jaxrsResponse.getMetadata().getFirst("Content-Type")) == null) {
                jaxrsResponse.getMetadata().putSingle("Content-Type", this.resolveContentType(request, jaxrsResponse.getEntity()));
            }
            ServerResponse serverResponse = jaxrsResponse;
            return serverResponse;
        }
        finally {
            uriInfo.popCurrentResource();
        }
    }

    protected ServerResponse invokeOnTarget(HttpRequest request, HttpResponse response, Object target) {
        for (PreProcessInterceptor preInterceptor : this.preProcessInterceptors) {
            ServerResponse serverResponse = preInterceptor.preProcess(request, this);
            if (serverResponse == null) continue;
            return this.prepareResponse(serverResponse);
        }
        Object rtn = null;
        try {
            rtn = this.methodInjector.invoke(request, response, target);
        }
        catch (WebApplicationException wae) {
            this.prepareResponse(ServerResponse.copyIfNotServerResponse(wae.getResponse()));
            throw wae;
        }
        if (request.isSuspended()) {
            AbstractAsynchronousResponse asyncResponse = (AbstractAsynchronousResponse)request.getAsynchronousResponse();
            if (asyncResponse == null) {
                return null;
            }
            asyncResponse.setAnnotations(this.method.getAnnotations());
            asyncResponse.setMessageBodyWriterInterceptors(this.writerInterceptors);
            asyncResponse.setPostProcessInterceptors(this.postProcessInterceptors);
            return null;
        }
        if (rtn == null || this.method.getReturnType().equals(Void.TYPE)) {
            return (ServerResponse)Response.noContent().build();
        }
        if (Response.class.isAssignableFrom(this.method.getReturnType()) || rtn instanceof Response) {
            return this.prepareResponse(ServerResponse.copyIfNotServerResponse((Response)rtn));
        }
        Response.ResponseBuilder builder = Response.ok(rtn);
        builder.type(this.resolveContentType(request, rtn));
        ServerResponse jaxrsResponse = (ServerResponse)builder.build();
        jaxrsResponse.setGenericType(this.genericReturnType);
        return this.prepareResponse(jaxrsResponse);
    }

    protected ServerResponse prepareResponse(ServerResponse serverResponse) {
        serverResponse.setAnnotations(this.method.getAnnotations());
        serverResponse.setMessageBodyWriterInterceptors(this.writerInterceptors);
        serverResponse.setPostProcessInterceptors(this.postProcessInterceptors);
        return serverResponse;
    }

    public boolean doesProduce(List<? extends MediaType> accepts) {
        if (accepts == null || accepts.size() == 0) {
            return true;
        }
        if (this.produces == null || this.produces.length == 0) {
            return true;
        }
        for (MediaType mediaType : accepts) {
            for (WeightedMediaType type : this.preferredProduces) {
                if (!((MediaType)type).isCompatible(mediaType)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean doesConsume(MediaType contentType) {
        boolean matches = false;
        if (contentType == null) {
            matches = true;
        } else if (this.consumes == null || this.consumes.length == 0) {
            matches = true;
        } else {
            for (WeightedMediaType type : this.preferredConsumes) {
                if (!((MediaType)type).isCompatible(contentType)) continue;
                matches = true;
                break;
            }
        }
        return matches;
    }

    protected MediaType resolveContentType(HttpRequest in, Object entity) {
        MediaType responseContentType = this.matchByType(in.getHttpHeaders().getAcceptableMediaTypes(), entity);
        if (responseContentType == null) {
            responseContentType = MediaType.WILDCARD_TYPE;
        }
        return responseContentType;
    }

    public MediaType matchByType(List<MediaType> accepts, Object entity) {
        if (accepts == null || accepts.size() == 0) {
            if (this.produces == null) {
                return MediaType.WILDCARD_TYPE;
            }
            return this.produces[0];
        }
        if (this.produces == null || this.produces.length == 0) {
            return this.resolveContentTypeByAccept(accepts, entity);
        }
        for (MediaType accept : accepts) {
            for (MediaType type : this.produces) {
                if (!type.isCompatible(accept)) continue;
                return type;
            }
        }
        return MediaType.WILDCARD_TYPE;
    }

    protected MediaType resolveContentTypeByAccept(List<MediaType> accepts, Object entity) {
        if (accepts == null || accepts.size() == 0 || entity == null) {
            return MediaType.WILDCARD_TYPE;
        }
        Class<?> clazz = entity.getClass();
        Type type = null;
        if (entity instanceof GenericEntity) {
            GenericEntity gen = (GenericEntity)entity;
            clazz = gen.getRawType();
            type = gen.getType();
        }
        for (MediaType accept : accepts) {
            if (this.providerFactory.getMessageBodyWriter(clazz, type, this.method.getAnnotations(), accept) == null) continue;
            return accept;
        }
        return MediaType.WILDCARD_TYPE;
    }

    public Set<String> getHttpMethods() {
        return this.httpMethods;
    }

    public MediaType[] getProduces() {
        return this.produces;
    }

    public MediaType[] getConsumes() {
        return this.consumes;
    }
}

