/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.http;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.BeanDefinitionDecorator;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.web.util.RegexUrlPathMatcher;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FilterChainMapBeanDefinitionDecorator
implements BeanDefinitionDecorator {
    public BeanDefinitionHolder decorate(Node node, BeanDefinitionHolder holder, ParserContext parserContext) {
        BeanDefinition filterChainProxy = holder.getBeanDefinition();
        LinkedHashMap<String, List> filterChainMap = new LinkedHashMap<String, List>();
        Element elt = (Element)node;
        String pathType = elt.getAttribute("path-type");
        if ("regex".equals(pathType)) {
            filterChainProxy.getPropertyValues().addPropertyValue("matcher", new RegexUrlPathMatcher());
        }
        List<Element> filterChainElts = DomUtils.getChildElementsByTagName(elt, "filter-chain");
        for (Element chain : filterChainElts) {
            String path = chain.getAttribute("pattern");
            String filters = chain.getAttribute("filters");
            if (!StringUtils.hasText(path)) {
                parserContext.getReaderContext().error("The attribute 'pattern' must not be empty", elt);
            }
            if (!StringUtils.hasText(filters)) {
                parserContext.getReaderContext().error("The attribute 'filters'must not be empty", elt);
            }
            if (filters.equals("none")) {
                filterChainMap.put(path, Collections.EMPTY_LIST);
                continue;
            }
            String[] filterBeanNames = StringUtils.tokenizeToStringArray(filters, ",");
            ManagedList<RuntimeBeanReference> filterChain = new ManagedList<RuntimeBeanReference>(filterBeanNames.length);
            for (int i = 0; i < filterBeanNames.length; ++i) {
                filterChain.add(new RuntimeBeanReference(filterBeanNames[i]));
            }
            filterChainMap.put(path, filterChain);
        }
        ManagedMap<String, List> map = new ManagedMap<String, List>(filterChainMap.size());
        map.putAll(filterChainMap);
        filterChainProxy.getPropertyValues().addPropertyValue("filterChainMap", map);
        return holder;
    }
}

